"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _use_overview_status = require("../../../../hooks/use_overview_status");
var _use_monitors_table_columns = require("../hooks/use_monitors_table_columns");
var _use_monitors_table_pagination = require("../hooks/use_monitors_table_pagination");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorsTable = ({
  items,
  setFlyoutConfigCallback
}) => {
  const {
    loaded,
    status,
    loading
  } = (0, _use_overview_status.useOverviewStatus)({
    scopeStatusByLocation: true
  });
  const {
    pageOfItems,
    pagination,
    onTableChange
  } = (0, _use_monitors_table_pagination.useMonitorsTablePagination)({
    totalItems: items
  });
  const {
    columns
  } = (0, _use_monitors_table_columns.useMonitorsTableColumns)({
    setFlyoutConfigCallback,
    items: pageOfItems
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const getRowProps = (0, _react.useCallback)(monitor => {
    const {
      configId,
      locationLabel,
      locationId,
      spaces
    } = monitor;
    return {
      onClick: e => {
        // This is a workaround to prevent the flyout from opening when clicking on the action buttons
        if (Array.from(e.target.classList).some(className => className.includes('euiTableCellContent') || className.includes('clickCellContent'))) {
          dispatch(setFlyoutConfigCallback({
            configId,
            id: configId,
            location: locationLabel,
            locationId,
            spaces
          }));
        }
      }
    };
  }, [dispatch, setFlyoutConfigCallback]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    compressed: true,
    items: pageOfItems,
    columns: columns,
    loading: !status || !loaded || loading,
    pagination: pagination,
    onChange: onTableChange,
    rowProps: getRowProps,
    "data-test-subj": "syntheticsCompactViewTable",
    tableLayout: "auto"
  });
};
exports.MonitorsTable = MonitorsTable;