"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorTestRunsCount = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _public3 = require("@kbn/exploratory-view-plugin/public");
var _use_monitor_filters = require("../../hooks/use_monitor_filters");
var _hooks = require("../../../../hooks");
var labels = _interopRequireWildcard(require("../labels"));
var _use_monitor_query_filters = require("../../hooks/use_monitor_query_filters");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorTestRunsCount = () => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const theme = (0, _public2.useTheme)();
  const {
    from,
    to
  } = (0, _hooks.useRefreshedRange)(30, 'days');
  const filters = (0, _use_monitor_filters.useMonitorFilters)({});
  const queryFilter = (0, _use_monitor_query_filters.useMonitorQueryFilters)();
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    dslFilters: queryFilter,
    align: "left",
    reportType: _public3.ReportTypes.SINGLE_METRIC,
    attributes: [{
      filters,
      time: {
        from,
        to
      },
      reportDefinitions: {
        'monitor.type': ['http', 'tcp', 'browser', 'icmp']
      },
      dataType: 'synthetics',
      selectedMetricField: 'monitor_total_runs',
      name: labels.TEST_RUNS_LABEL,
      color: theme.eui.euiColorVis1
    }]
  });
};
exports.MonitorTestRunsCount = MonitorTestRunsCount;