"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorListHeader = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _show_all_spaces = require("../../common/show_all_spaces");
var _bulk_operations = require("./bulk_operations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorListHeader = ({
  selectedItems,
  recordRangeLabel,
  setMonitorPendingDeletion
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement("span", null, recordRangeLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_bulk_operations.BulkOperations, {
    selectedItems: selectedItems,
    setMonitorPendingDeletion: setMonitorPendingDeletion
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_show_all_spaces.ShowAllSpaces, null)));
};
exports.MonitorListHeader = MonitorListHeader;