"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _monitor_list_header = require("./monitor_list_header");
var _delete_monitor = require("./delete_monitor");
var _runtime_types = require("../../../../../../../common/runtime_types");
var _columns = require("./columns");
var labels = _interopRequireWildcard(require("./labels"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getEmptyFunctionComponent = ({
  children
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
const MonitorList = ({
  pageState: {
    pageIndex,
    pageSize,
    sortField,
    sortOrder
  },
  syntheticsMonitors,
  total,
  error,
  loading,
  overviewStatus,
  loadPage,
  reloadPage
}) => {
  var _error$body, _syntheticsMonitors$f, _syntheticsMonitors$f2, _syntheticsMonitors$f3;
  const isXl = (0, _eui.useIsWithinMinBreakpoint)('xxl');
  const [monitorPendingDeletion, setMonitorPendingDeletion] = (0, _react.useState)([]);
  const handleOnChange = (0, _react.useCallback)(({
    page = {
      index: 0,
      size: 10
    },
    sort = {
      field: _runtime_types.ConfigKey.NAME,
      direction: 'asc'
    }
  }) => {
    const {
      index,
      size
    } = page;
    const {
      field,
      direction
    } = sort;
    loadPage({
      pageIndex: index,
      pageSize: size,
      sortField: field === 'enabled' ? field : `${field}.keyword`,
      sortOrder: direction
    });
  }, [loadPage]);
  const pagination = {
    pageIndex,
    pageSize,
    totalItemCount: total,
    pageSizeOptions: [5, 10, 25, 50, 100]
  };
  const sorting = {
    sort: {
      field: sortField === null || sortField === void 0 ? void 0 : sortField.replace('.keyword', ''),
      direction: sortOrder
    }
  };
  const recordRangeLabel = labels.getRecordRangeLabel({
    rangeStart: total === 0 ? 0 : pageSize * pageIndex + 1,
    rangeEnd: pageSize * pageIndex + pageSize,
    total
  });
  const columns = (0, _columns.useMonitorListColumns)({
    loading,
    overviewStatus,
    setMonitorPendingDeletion
  });
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const onSelectionChange = selItems => {
    setSelectedItems(selItems);
  };
  const selection = {
    onSelectionChange,
    initialSelected: selectedItems
  };
  const {
    spaces: spacesApi
  } = (0, _public.useKibana)().services;
  const ContextWrapper = (0, _react.useMemo)(() => spacesApi ? spacesApi.ui.components.getSpacesContextProvider : getEmptyFunctionComponent, [spacesApi]);
  return /*#__PURE__*/_react.default.createElement(ContextWrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_monitor_list_header.MonitorListHeader, {
    recordRangeLabel: recordRangeLabel,
    selectedItems: selectedItems,
    setMonitorPendingDeletion: setMonitorPendingDeletion
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "aria-label": _i18n.i18n.translate('xpack.synthetics.management.monitorList.title', {
      defaultMessage: 'Synthetics monitors list'
    }),
    error: error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message,
    loading: loading,
    itemId: "config_id",
    items: syntheticsMonitors,
    columns: columns,
    tableLayout: isXl ? 'auto' : 'fixed',
    pagination: pagination,
    sorting: sorting,
    onChange: handleOnChange,
    noItemsMessage: loading ? labels.LOADING : labels.NO_DATA_MESSAGE,
    selection: selection
  })), monitorPendingDeletion.length > 0 && /*#__PURE__*/_react.default.createElement(_delete_monitor.DeleteMonitor, {
    configIds: monitorPendingDeletion,
    name: (_syntheticsMonitors$f = (_syntheticsMonitors$f2 = syntheticsMonitors.find(mon => mon[_runtime_types.ConfigKey.CONFIG_ID] === monitorPendingDeletion[0])) === null || _syntheticsMonitors$f2 === void 0 ? void 0 : _syntheticsMonitors$f2[_runtime_types.ConfigKey.NAME]) !== null && _syntheticsMonitors$f !== void 0 ? _syntheticsMonitors$f : '',
    setMonitorPendingDeletion: setMonitorPendingDeletion,
    isProjectMonitor: ((_syntheticsMonitors$f3 = syntheticsMonitors.find(mon => mon[_runtime_types.ConfigKey.CONFIG_ID] === monitorPendingDeletion[0])) === null || _syntheticsMonitors$f3 === void 0 ? void 0 : _syntheticsMonitors$f3[_runtime_types.ConfigKey.MONITOR_SOURCE_TYPE]) === _runtime_types.SourceType.PROJECT,
    reloadPage: reloadPage
  }));
};
exports.MonitorList = MonitorList;