"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _availability_panel = require("./availability_panel");
var _availability_sparklines = require("./availability_sparklines");
var _duration_panel = require("./duration_panel");
var _duration_sparklines = require("./duration_sparklines");
var _monitor_errors_count = require("./monitor_errors_count");
var _monitor_error_sparklines = require("./monitor_error_sparklines");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SummaryPanel = ({
  dateLabel,
  from,
  to
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    grow: false,
    hasBorder: true,
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, SUMMARY_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, dateLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 120
    }
  }, /*#__PURE__*/_react.default.createElement(_availability_panel.AvailabilityPanel, {
    from: from,
    to: to,
    id: "availabilityPercentageSummary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(_availability_sparklines.AvailabilitySparklines, {
    from: from,
    to: to,
    id: "availabilitySparklineSummary"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 120
    }
  }, /*#__PURE__*/_react.default.createElement(_duration_panel.DurationPanel, {
    from: from,
    to: to,
    id: "durationAvgValueSummary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(_duration_sparklines.DurationSparklines, {
    from: from,
    to: to,
    id: "durationAvgSparklineSummary"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    wrap: false,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: 80
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_errors_count.MonitorErrorsCount, {
    from: from,
    to: to,
    id: "monitorErrorsCountSummary"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 100
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_error_sparklines.MonitorErrorSparklines, {
    from: from,
    to: to,
    id: "monitorErrorsSparklineSummary"
  }))))));
};
exports.SummaryPanel = SummaryPanel;
const SUMMARY_LABEL = _i18n.i18n.translate('xpack.synthetics.detailsPanel.summary', {
  defaultMessage: 'Summary'
});