"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _filter_status_button = require("../../common/components/filter_status_button");
var _translations = require("../../../../../../common/translations/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StatusFilter = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(_filter_status_button.FilterStatusButton, {
    content: _i18n.i18n.translate('xpack.synthetics.filterBar.filterAllLabel', {
      defaultMessage: 'All'
    }),
    dataTestSubj: "xpack.synthetics.filterBar.filterStatusAll",
    value: undefined,
    withNext: true
  }), /*#__PURE__*/_react.default.createElement(_filter_status_button.FilterStatusButton, {
    content: _translations.STATUS_UP_LABEL,
    dataTestSubj: "xpack.synthetics.filterBar.filterStatusUp",
    value: "up",
    withNext: true
  }), /*#__PURE__*/_react.default.createElement(_filter_status_button.FilterStatusButton, {
    content: _translations.STATUS_DOWN_LABEL,
    dataTestSubj: "xpack.synthetics.filterBar.filterStatusDown",
    value: "down",
    withNext: false
  }));
};
exports.StatusFilter = StatusFilter;