"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getErrorDetailsRouteConfig = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _monitor_details_location = require("../monitor_details/monitor_details_location");
var _resolved_at = require("./components/resolved_at");
var _error_started_at = require("./components/error_started_at");
var _error_details_page = require("./error_details_page");
var _error_duration = require("./components/error_duration");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getErrorDetailsRouteConfig = (history, syntheticsPath, baseTitle) => {
  return {
    title: _i18n.i18n.translate('xpack.synthetics.errorDetailsRoute.title', {
      defaultMessage: 'Error details | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.ERROR_DETAILS_ROUTE,
    component: _error_details_page.ErrorDetailsPage,
    dataTestSubj: 'syntheticsMonitorEditPage',
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.synthetics.editMonitor.errorDetailsRoute.title",
        defaultMessage: "Error details"
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_error_duration.ErrorDuration, null), /*#__PURE__*/_react.default.createElement(_monitor_details_location.MonitorDetailsLocation, {
        isDisabled: true
      }), /*#__PURE__*/_react.default.createElement(_resolved_at.ResolvedAt, null), /*#__PURE__*/_react.default.createElement(_error_started_at.ErrorStartedAt, null)]
    }
  };
};
exports.getErrorDetailsRouteConfig = getErrorDetailsRouteConfig;