"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wiredIngestStreamEffectiveLifecycleSchema = exports.unwiredIngestStreamEffectiveLifecycleSchema = exports.isInheritLifecycle = exports.isIlmLifecycle = exports.isErrorLifecycle = exports.isDslLifecycle = exports.isDisabledLifecycle = exports.ingestStreamLifecycleSchema = exports.ingestStreamEffectiveLifecycleSchema = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _type_guards = require("../../../shared/type_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dslLifecycleSchema = _zod.z.object({
  dsl: _zod.z.object({
    data_retention: _zod.z.optional(_zodHelpers.NonEmptyString)
  })
});
const ilmLifecycleSchema = _zod.z.object({
  ilm: _zod.z.object({
    policy: _zodHelpers.NonEmptyString
  })
});
const inheritLifecycleSchema = _zod.z.object({
  inherit: _zod.z.strictObject({})
});
const disabledLifecycleSchema = _zod.z.object({
  disabled: _zod.z.strictObject({})
});
const errorLifecycleSchema = _zod.z.object({
  error: _zod.z.strictObject({
    message: _zodHelpers.NonEmptyString
  })
});
const ingestStreamLifecycleSchema = exports.ingestStreamLifecycleSchema = _zod.z.union([dslLifecycleSchema, ilmLifecycleSchema, inheritLifecycleSchema]);
const unwiredIngestStreamEffectiveLifecycleSchema = exports.unwiredIngestStreamEffectiveLifecycleSchema = _zod.z.union([ingestStreamLifecycleSchema, disabledLifecycleSchema, errorLifecycleSchema]);
const wiredIngestStreamEffectiveLifecycleSchema = exports.wiredIngestStreamEffectiveLifecycleSchema = ingestStreamLifecycleSchema.and(_zod.z.object({
  from: _zodHelpers.NonEmptyString
}));
const ingestStreamEffectiveLifecycleSchema = exports.ingestStreamEffectiveLifecycleSchema = _zod.z.union([unwiredIngestStreamEffectiveLifecycleSchema, wiredIngestStreamEffectiveLifecycleSchema]);
const isDslLifecycle = exports.isDslLifecycle = (0, _type_guards.createIsNarrowSchema)(ingestStreamEffectiveLifecycleSchema, dslLifecycleSchema);
const isErrorLifecycle = exports.isErrorLifecycle = (0, _type_guards.createIsNarrowSchema)(unwiredIngestStreamEffectiveLifecycleSchema, errorLifecycleSchema);
const isIlmLifecycle = exports.isIlmLifecycle = (0, _type_guards.createIsNarrowSchema)(ingestStreamEffectiveLifecycleSchema, ilmLifecycleSchema);
const isInheritLifecycle = exports.isInheritLifecycle = (0, _type_guards.createIsNarrowSchema)(ingestStreamEffectiveLifecycleSchema, inheritLifecycleSchema);
const isDisabledLifecycle = exports.isDisabledLifecycle = (0, _type_guards.createIsNarrowSchema)(ingestStreamEffectiveLifecycleSchema, disabledLifecycleSchema);