"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unaryFilterConditionSchema = exports.orConditionSchema = exports.neverConditionSchema = exports.isUnaryFilterCondition = exports.isOrCondition = exports.isNeverCondition = exports.isFilterCondition = exports.isCondition = exports.isBinaryFilterCondition = exports.isAndCondition = exports.isAlwaysCondition = exports.filterConditionSchema = exports.conditionSchema = exports.binaryFilterConditionSchema = exports.andConditionSchema = exports.alwaysConditionSchema = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _type_guards = require("../shared/type_guards");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stringOrNumberOrBoolean = _zod.z.union([_zod.z.string(), _zod.z.number(), _zod.z.boolean()]);
const binaryFilterConditionSchema = exports.binaryFilterConditionSchema = _zod.z.object({
  field: _zodHelpers.NonEmptyString,
  operator: _zod.z.enum(['eq', 'neq', 'lt', 'lte', 'gt', 'gte', 'contains', 'startsWith', 'endsWith']),
  value: stringOrNumberOrBoolean
});
const unaryFilterConditionSchema = exports.unaryFilterConditionSchema = _zod.z.object({
  field: _zodHelpers.NonEmptyString,
  operator: _zod.z.enum(['exists', 'notExists'])
});
const filterConditionSchema = exports.filterConditionSchema = _zod.z.union([unaryFilterConditionSchema, binaryFilterConditionSchema]);
const conditionSchema = exports.conditionSchema = _zod.z.lazy(() => _zod.z.union([filterConditionSchema, andConditionSchema, orConditionSchema, neverConditionSchema, alwaysConditionSchema]));
const andConditionSchema = exports.andConditionSchema = _zod.z.object({
  and: _zod.z.array(conditionSchema)
});
const orConditionSchema = exports.orConditionSchema = _zod.z.object({
  or: _zod.z.array(conditionSchema)
});
const neverConditionSchema = exports.neverConditionSchema = _zod.z.object({
  never: _zod.z.strictObject({})
});
const alwaysConditionSchema = exports.alwaysConditionSchema = _zod.z.object({
  always: _zod.z.strictObject({})
});
const isBinaryFilterCondition = exports.isBinaryFilterCondition = (0, _type_guards.createIsNarrowSchema)(conditionSchema, binaryFilterConditionSchema);
const isUnaryFilterCondition = exports.isUnaryFilterCondition = (0, _type_guards.createIsNarrowSchema)(conditionSchema, unaryFilterConditionSchema);
const isFilterCondition = exports.isFilterCondition = (0, _type_guards.createIsNarrowSchema)(conditionSchema, filterConditionSchema);
const isAndCondition = exports.isAndCondition = (0, _type_guards.createIsNarrowSchema)(conditionSchema, andConditionSchema);
const isOrCondition = exports.isOrCondition = (0, _type_guards.createIsNarrowSchema)(conditionSchema, orConditionSchema);
const isNeverCondition = exports.isNeverCondition = (0, _type_guards.createIsNarrowSchema)(conditionSchema, neverConditionSchema);
const isAlwaysCondition = exports.isAlwaysCondition = (0, _type_guards.createIsNarrowSchema)(conditionSchema, alwaysConditionSchema);
const isCondition = exports.isCondition = (0, _type_guards.createIsNarrowSchema)(_zod.z.unknown(), conditionSchema);