"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIndexPatterns = getIndexPatterns;
var _streamsSchema = require("@kbn/streams-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getIndexPatterns(stream) {
  if (!stream) {
    return undefined;
  }
  if (_streamsSchema.Streams.UnwiredStream.Definition.is(stream)) {
    return [stream.name];
  }
  const isRoot = stream.name.indexOf('.') === -1;
  const dataStreamOfDefinition = stream.name;
  return isRoot ? [dataStreamOfDefinition, `${dataStreamOfDefinition}.*`] : [`${dataStreamOfDefinition}*`];
}