"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamsAppRouter = void 0;
var _i18n = require("@kbn/i18n");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _streams_app_page_template = require("../components/streams_app_page_template");
var _streams_app_router_breadcrumb = require("../components/streams_app_router_breadcrumb");
var _redirect_to = require("../components/redirect_to");
var _stream_list_view = require("../components/stream_list_view");
var _stream_root = require("../components/stream_root");
var _stream_detail_management = require("../components/data_management/stream_detail_management");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The array of route definitions to be used when the application
 * creates the routes.
 */
const streamsAppRoutes = {
  '/': {
    element: /*#__PURE__*/_react.default.createElement(_streams_app_router_breadcrumb.StreamsAppRouterBreadcrumb, {
      title: _i18n.i18n.translate('xpack.streams.appBreadcrumbTitle', {
        defaultMessage: 'Streams'
      }),
      path: "/"
    }, /*#__PURE__*/_react.default.createElement(_streams_app_page_template.StreamsAppPageTemplate, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null))),
    children: {
      '/': {
        element: /*#__PURE__*/_react.default.createElement(_stream_list_view.StreamListView, null)
      },
      '/{key}': {
        element: /*#__PURE__*/_react.default.createElement(_stream_root.StreamDetailRoot, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, null)),
        params: t.type({
          path: t.type({
            key: t.string
          })
        }),
        children: {
          '/{key}': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              path: "/{key}/management/{tab}",
              params: {
                path: {
                  tab: 'lifecycle'
                }
              }
            })
          },
          /**
           * This route matching the StreamDetailView will be temporarily disable as it does not provide additional value than the stream list and lifecycle view
           */
          // '/{key}/{tab}': {
          //   element: <StreamDetailView />,
          //   params: t.type({
          //     path: t.type({
          //       tab: t.string,
          //     }),
          //   }),
          // },
          /**
           * This route is added as a replacement of the old StreamDetailView routing to redirect from existing overview/dashboard links into the management page
           */
          '/{key}/{tab}': {
            element: /*#__PURE__*/_react.default.createElement(_redirect_to.RedirectTo, {
              path: "/{key}/management/{tab}",
              params: {
                path: {
                  tab: 'lifecycle'
                }
              }
            }),
            params: t.type({
              path: t.type({
                tab: t.string
              })
            })
          },
          '/{key}/management/{tab}': {
            element: /*#__PURE__*/_react.default.createElement(_stream_detail_management.StreamDetailManagement, null),
            params: t.type({
              path: t.type({
                tab: t.string
              })
            })
          }
        }
      }
    }
  }
};
const streamsAppRouter = exports.streamsAppRouter = (0, _typedReactRouterConfig.createRouter)(streamsAppRoutes);