"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionColumn = RetentionColumn;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _indexLifecycleManagementCommonShared = require("@kbn/index-lifecycle-management-common-shared");
var _streamsSchema = require("@kbn/streams-schema");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RetentionColumn({
  lifecycle
}) {
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const ilmLocator = share.url.locators.get(_indexLifecycleManagementCommonShared.ILM_LOCATOR_ID);
  if ((0, _streamsSchema.isErrorLifecycle)(lifecycle)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, lifecycle.error.message);
  }
  if ((0, _streamsSchema.isIlmLifecycle)(lifecycle)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "streamsAppLifecycleBadgeIlmPolicyNameLink",
      color: "text",
      href: ilmLocator === null || ilmLocator === void 0 ? void 0 : ilmLocator.getRedirectUrl({
        page: 'policy_edit',
        policyName: lifecycle.ilm.policy
      }),
      target: "_blank"
    }, _i18n.i18n.translate('xpack.streams.streamsRetentionColumn.ilmBadgeLabel', {
      defaultMessage: 'ILM policy: {name}',
      values: {
        name: lifecycle.ilm.policy
      }
    })));
  }
  if ((0, _streamsSchema.isDslLifecycle)(lifecycle)) {
    return lifecycle.dsl.data_retention || /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "infinity",
      size: "m"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, _i18n.i18n.translate('xpack.streams.streamsRetentionColumn.noDataLabel', {
    defaultMessage: 'N/A'
  }));
}