"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailOverview = StreamDetailOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _quick_links = require("./quick_links");
var _child_stream_list = require("./child_stream_list");
var _stream_stats_panel = require("./components/stream_stats_panel");
var _stream_chart_panel = require("./components/stream_chart_panel");
var _tabs_panel = require("./components/tabs_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function StreamDetailOverview({
  definition
}) {
  const tabs = (0, _react.useMemo)(() => [...(definition && _streamsSchema.Streams.WiredStream.GetResponse.is(definition) ? [{
    id: 'streams',
    name: _i18n.i18n.translate('xpack.streams.entityDetailOverview.tabs.streams', {
      defaultMessage: 'Streams'
    }),
    content: /*#__PURE__*/_react.default.createElement(_child_stream_list.ChildStreamList, {
      definition: definition
    })
  }] : []), {
    id: 'quicklinks',
    name: _i18n.i18n.translate('xpack.streams.entityDetailOverview.tabs.quicklinks', {
      defaultMessage: 'Quick Links'
    }),
    content: /*#__PURE__*/_react.default.createElement(_quick_links.QuickLinks, {
      definition: definition
    })
  }], [definition]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_stream_stats_panel.StreamStatsPanel, {
    definition: definition
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_tabs_panel.TabsPanel, {
    tabs: tabs
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 8
  }, /*#__PURE__*/_react.default.createElement(_stream_chart_panel.StreamChartPanel, {
    definition: definition
  }))))));
}