"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmLink = IlmLink;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _indexLifecycleManagementCommonShared = require("@kbn/index-lifecycle-management-common-shared");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function IlmLink({
  lifecycle
}) {
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const ilmLocator = share.url.locators.get(_indexLifecycleManagementCommonShared.ILM_LOCATOR_ID);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    "data-test-subj": "streamsAppLifecycleBadgeIlmPolicyNameLink",
    href: ilmLocator === null || ilmLocator === void 0 ? void 0 : ilmLocator.getRedirectUrl({
      page: 'policy_edit',
      policyName: lifecycle.ilm.policy
    })
  }, _i18n.i18n.translate('xpack.streams.entityDetailViewWithoutParams.ilmBadgeLabel', {
    defaultMessage: 'ILM Policy: {name}',
    values: {
      name: lifecycle.ilm.policy
    }
  }));
}