"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUpsertStreamActor = createUpsertStreamActor;
exports.createUpsertStreamSuccessNofitier = exports.createUpsertStreamFailureNofitier = void 0;
var _streamsSchema = require("@kbn/streams-schema");
var _xstate = require("xstate5");
var _i18n = require("@kbn/i18n");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createUpsertStreamActor({
  streamsRepositoryClient
}) {
  return (0, _xstate.fromPromise)(({
    input,
    signal
  }) => {
    return streamsRepositoryClient.fetch(`PUT /api/streams/{name}/_ingest 2023-10-31`, {
      signal,
      params: {
        path: {
          name: input.definition.stream.name
        },
        body: _streamsSchema.Streams.WiredStream.GetResponse.is(input.definition) ? {
          ingest: {
            ...input.definition.stream.ingest,
            processing: input.processors.map(_utils.processorConverter.toAPIDefinition),
            ...(input.fields && {
              wired: {
                ...input.definition.stream.ingest.wired,
                fields: input.fields
              }
            })
          }
        } : {
          ingest: {
            ...input.definition.stream.ingest,
            processing: input.processors.map(_utils.processorConverter.toAPIDefinition)
          }
        }
      }
    });
  });
}
const createUpsertStreamSuccessNofitier = ({
  toasts
}) => () => {
  toasts.addSuccess(_i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.saveChangesSuccess', {
    defaultMessage: "Stream's processors updated"
  }));
};
exports.createUpsertStreamSuccessNofitier = createUpsertStreamSuccessNofitier;
const createUpsertStreamFailureNofitier = ({
  toasts
}) => params => {
  const event = params.event;
  toasts.addError(new Error(event.error.body.message), {
    title: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.saveChangesError', {
      defaultMessage: "An issue occurred saving processors' changes."
    }),
    toastMessage: event.error.body.message
  });
};
exports.createUpsertStreamFailureNofitier = createUpsertStreamFailureNofitier;