"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourceCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _objectUtils = require("@kbn/object-utils");
var _use_discard_confirm = require("../../../../hooks/use_discard_confirm");
var _data_source_state_machine = require("../state_management/data_source_state_machine");
var _asset_image = require("../../../asset_image");
var _preview_table = require("../../preview_table");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataSourceCard = ({
  children,
  dataSourceRef,
  title,
  subtitle,
  isPreviewVisible
}) => {
  const dataSourceState = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => snapshot);
  const {
    data: previewDocs,
    dataSource
  } = dataSourceState.context;
  const canDeleteDataSource = dataSourceState.can({
    type: 'dataSource.delete'
  });
  const isEnabled = dataSourceState.matches('enabled');
  const isLoading = dataSourceState.matches({
    enabled: 'loadingData'
  }) || dataSourceState.matches({
    enabled: 'debouncingChanges'
  });
  const toggleActivity = () => dataSourceRef.send({
    type: 'dataSource.toggleActivity'
  });
  const deleteDataSource = (0, _use_discard_confirm.useDiscardConfirm)(() => dataSourceRef.send({
    type: 'dataSource.delete'
  }), {
    title: _translations.DATA_SOURCES_I18N.dataSourceCard.delete.title,
    message: _translations.DATA_SOURCES_I18N.dataSourceCard.delete.message,
    cancelButtonText: _translations.DATA_SOURCES_I18N.dataSourceCard.delete.cancelButtonText,
    confirmButtonText: _translations.DATA_SOURCES_I18N.dataSourceCard.delete.confirmButtonText
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: `dataSourceCard-${dataSourceRef.id}`,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, title !== null && title !== void 0 ? title : dataSource.type)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "success",
      isDisabled: !isEnabled
    }, isEnabled ? _translations.DATA_SOURCES_I18N.dataSourceCard.enabled : _translations.DATA_SOURCES_I18N.dataSourceCard.disabled)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }), canDeleteDataSource && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      onClick: deleteDataSource,
      "aria-label": _translations.DATA_SOURCES_I18N.dataSourceCard.deleteDataSourceLabel
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      component: "p",
      color: "subdued",
      size: "xs"
    }, subtitle)),
    checkableType: "checkbox",
    onChange: toggleActivity,
    checked: isEnabled
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: dataSourceRef.id,
    buttonContent: _translations.DATA_SOURCES_I18N.dataSourceCard.dataPreviewAccordionLabel,
    initialIsOpen: isPreviewVisible
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }), (0, _lodash.isEmpty)(previewDocs) ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "noResults",
      size: "s"
    }),
    titleSize: "xs",
    title: /*#__PURE__*/_react.default.createElement("h4", null, _translations.DATA_SOURCES_I18N.dataSourceCard.noDataPreview)
  }) : /*#__PURE__*/_react.default.createElement(_preview_table.PreviewTable, {
    documents: previewDocs.map(_objectUtils.flattenObjectNestedLast),
    height: 150
  })));
};
exports.DataSourceCard = DataSourceCard;