"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.severityOptions = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/xsoar/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const severityOptions = exports.severityOptions = [{
  value: _constants.XSOARSeverity.UNKNOWN,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.eventSelectSeverityUnknownOptionLabel', {
    defaultMessage: 'Unknown'
  })
}, {
  value: _constants.XSOARSeverity.INFORMATIONAL,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.eventSelectSeverityInformationalOptionLabel', {
    defaultMessage: 'Informational'
  })
}, {
  value: _constants.XSOARSeverity.LOW,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.eventSelectSeverityLowOptionLabel', {
    defaultMessage: 'Low'
  })
}, {
  value: _constants.XSOARSeverity.MEDIUM,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.eventSelectSeverityMediumOptionLabel', {
    defaultMessage: 'Medium'
  })
}, {
  value: _constants.XSOARSeverity.HIGH,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.eventSelectSeverityHighOptionLabel', {
    defaultMessage: 'High'
  })
}, {
  value: _constants.XSOARSeverity.CRITICAL,
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xsoar.eventSelectSeverityCriticalOptionLabel', {
    defaultMessage: 'Critical'
  })
}];