"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApplication = getApplication;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const removeUnsafeFields = fields => fields.filter(filter => filter.id !== '__proto__' && filter.key !== '__proto__' && filter.name !== '__proto__' && filter.fieldType !== '__proto__');
async function getApplication({
  signal,
  url,
  appId,
  apiToken
}) {
  const headers = {
    'Content-Type': 'application/json',
    'Private-Token': `${apiToken}`
  };
  const urlWithoutTrailingSlash = url.endsWith('/') ? url.slice(0, -1) : url;
  const apiUrl = urlWithoutTrailingSlash.endsWith('api') ? urlWithoutTrailingSlash : urlWithoutTrailingSlash + '/api';
  const applicationUrl = `${apiUrl}/app/{appId}`;
  const getApplicationUrl = id => applicationUrl.replace('{appId}', id);
  try {
    var _data$fields;
    const response = await fetch(getApplicationUrl(appId), {
      method: 'GET',
      headers,
      signal
    });

    /**
     * Fetch do not throw when there is an HTTP error (status >= 400).
     * We need to do it manually.
     */

    if (!response.ok) {
      throw new Error(`Received status: ${response.status} when attempting to get application with id: ${appId}`);
    }
    const data = await response.json();
    return {
      ...data,
      fields: removeUnsafeFields((_data$fields = data === null || data === void 0 ? void 0 : data.fields) !== null && _data$fields !== void 0 ? _data$fields : [])
    };
  } catch (error) {
    throw new Error(`Unable to get application with id ${appId}. Error: ${error.message}`);
  }
}