"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleFieldSelect = SingleFieldSelect;
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactField = require("@kbn/react-field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function fieldsToOptions(fields) {
  if (!fields) {
    return [];
  }
  return fields.map(field => ({
    value: field,
    label: field.name
  })).sort((a, b) => {
    return a.label.toLowerCase().localeCompare(b.label.toLowerCase());
  });
}
function SingleFieldSelect({
  isInvalid,
  placeholder,
  value,
  onChange,
  fields
}) {
  function renderOption(option, searchValue, contentClassName) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: contentClassName,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: null
    }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      type: option.value.type,
      fill: "none"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue
    }, option.label)));
  }
  const onSelection = selectedOptions => {
    onChange(_lodash.default.get(selectedOptions, '0.value.name'));
  };
  const selectedOptions = [];
  if (value && fields) {
    const selectedField = fields.find(field => field.name === value);
    if (selectedField) {
      selectedOptions.push({
        value: selectedField,
        label: value
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    isInvalid: isInvalid,
    singleSelection: true,
    options: fieldsToOptions(fields),
    selectedOptions: selectedOptions,
    onChange: onSelection,
    isDisabled: !fields,
    renderOption: renderOption,
    isClearable: false,
    placeholder: placeholder
  });
}