"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpaceResultProcessing = exports.SpaceResult = void 0;
require("./space_result.scss");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _copy_status_summary_indicator = require("./copy_status_summary_indicator");
var _space_result_details = require("./space_result_details");
var _space_avatar = require("../../space_avatar");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// No need to wrap LazySpaceAvatar in an error boundary, because it is one of the first chunks loaded when opening Kibana.
const LazySpaceAvatar = /*#__PURE__*/(0, _react.lazy)(() => (0, _space_avatar.getSpaceAvatarComponent)().then(component => ({
  default: component
})));
const getInitialDestinationMap = objects => objects.reduce((acc, {
  type,
  id,
  conflict
}) => {
  if ((conflict === null || conflict === void 0 ? void 0 : conflict.error.type) === 'ambiguous_conflict') {
    acc.set(`${type}:${id}`, conflict.error.destinations[0].id);
  }
  return acc;
}, new Map());
const SpaceResultProcessing = props => {
  const {
    space
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `copyToSpace-${space.id}`,
    "data-test-subj": `cts-space-result-${space.id}`,
    className: "spcCopyToSpaceResult",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
      space: space,
      size: "s"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, space.name))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null));
};
exports.SpaceResultProcessing = SpaceResultProcessing;
const SpaceResult = props => {
  const {
    space,
    summarizedCopyResult,
    retries,
    onRetriesChange,
    conflictResolutionInProgress
  } = props;
  const {
    objects
  } = summarizedCopyResult;
  const spaceHasPendingOverwrites = retries.some(r => r.overwrite);
  const [destinationMap, setDestinationMap] = (0, _react.useState)(getInitialDestinationMap(objects));
  const onDestinationMapChange = value => {
    setDestinationMap(value || getInitialDestinationMap(objects));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: `copyToSpace-${space.id}`,
    "data-test-subj": `cts-space-result-${space.id}`,
    className: "spcCopyToSpaceResult",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
      fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
    }, /*#__PURE__*/_react.default.createElement(LazySpaceAvatar, {
      space: space,
      size: "s"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, space.name))),
    extraAction: /*#__PURE__*/_react.default.createElement(_copy_status_summary_indicator.CopyStatusSummaryIndicator, {
      space: space,
      retries: retries,
      onRetriesChange: onRetriesChange,
      onDestinationMapChange: onDestinationMapChange,
      summarizedCopyResult: summarizedCopyResult,
      conflictResolutionInProgress: conflictResolutionInProgress && spaceHasPendingOverwrites
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_space_result_details.SpaceCopyResultDetails, {
    summarizedCopyResult: summarizedCopyResult,
    space: space,
    retries: retries,
    onRetriesChange: onRetriesChange,
    destinationMap: destinationMap,
    onDestinationMapChange: onDestinationMapChange,
    conflictResolutionInProgress: conflictResolutionInProgress && spaceHasPendingOverwrites
  }));
};
exports.SpaceResult = SpaceResult;