"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLookbackDateRange = getLookbackDateRange;
var _moment = _interopRequireDefault(require("moment"));
var _models = require("../models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLookbackDateRange(startedAt, duration, delayInSeconds = 0) {
  const unit = (0, _models.toMomentUnitOfTime)(duration.unit);
  const now = (0, _moment.default)(startedAt).subtract(delayInSeconds, 'seconds').startOf('minute');
  const from = now.clone().subtract(duration.value, unit).startOf('minute');
  return {
    from: from.toDate(),
    to: now.toDate()
  };
}