"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloSparkline = SloSparkline;
var _charts = require("@elastic/charts");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloSparkline({
  chart,
  data,
  id,
  isLoading,
  size,
  state
}) {
  const charts = (0, _use_kibana.useKibana)().services.charts;
  const baseTheme = charts.theme.useChartsBaseTheme();
  const sparklineTheme = charts.theme.useSparklineOverrides();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const color = state === 'error' ? euiTheme.colors.danger : euiTheme.colors.success;
  const ChartComponent = chart === 'area' ? _charts.AreaSeries : _charts.LineSeries;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      style: {
        minWidth: 60,
        justifyContent: 'center'
      },
      size: "m"
    });
  }
  const height = size === 'compact' ? 14 : 28;
  const width = size === 'compact' ? 40 : 60;
  return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height,
      width
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: false,
    theme: sparklineTheme,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "axis",
    hide: true,
    domain: {
      min: NaN,
      max: NaN,
      fit: true
    },
    gridLine: {
      visible: false
    }
  }), /*#__PURE__*/_react.default.createElement(ChartComponent, {
    color: color,
    data: data,
    fit: _charts.Fit.Nearest,
    id: id,
    lineSeriesStyle: {
      point: {
        visible: 'never'
      }
    },
    xAccessor: 'key'
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yAccessors: ['value'],
    yScaleType: _charts.ScaleType.Linear
  }));
}