"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloManagementSearchBar = SloManagementSearchBar;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-shared-plugin/common");
var _use_fetch_suggestions = require("../../slo_edit/hooks/use_fetch_suggestions");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_url_search_state = require("../hooks/use_url_search_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloManagementSearchBar({
  onRefresh
}) {
  const {
    state,
    onStateChange
  } = (0, _use_url_search_state.useUrlSearchState)();
  const {
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _use_kibana.useKibana)().services;
  const {
    suggestions
  } = (0, _use_fetch_suggestions.useFetchSLOSuggestions)();
  const [selectedOptions, setSelectedOptions] = (0, _react.useState)([]);
  return /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: _common.observabilityAppId,
    placeholder: _i18n.i18n.translate('xpack.slo.sloDefinitions.filterByName', {
      defaultMessage: 'Filter by name'
    }),
    isAutoRefreshDisabled: true,
    disableQueryLanguageSwitcher: true,
    nonKqlMode: "text",
    showQueryMenu: false,
    showDatePicker: false,
    showSavedQueryControls: false,
    showFilterBar: false,
    query: {
      query: state.search,
      language: 'text'
    },
    onQuerySubmit: ({
      query: value
    }) => {
      onStateChange({
        ...state,
        search: value !== null && value !== void 0 && value.query ? value === null || value === void 0 ? void 0 : value.query : ''
      });
    },
    onRefresh: onRefresh,
    renderQueryInputAppend: () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      "aria-label": filterTagsLabel,
      placeholder: filterTagsLabel,
      delimiter: ",",
      options: suggestions !== null && suggestions !== void 0 && suggestions.tags ? [existOption, ...(suggestions === null || suggestions === void 0 ? void 0 : suggestions.tags)] : [],
      selectedOptions: selectedOptions,
      onChange: newOptions => {
        setSelectedOptions(newOptions);
        onStateChange({
          ...state,
          tags: newOptions.map(option => String(option.value))
        });
      },
      isClearable: true,
      "data-test-subj": "filter-slos-by-tag"
    }))
  });
}
const filterTagsLabel = _i18n.i18n.translate('xpack.slo.sloDefinitions.filterByTag', {
  defaultMessage: 'Filter tags'
});
const existOption = {
  prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement("em", null, _i18n.i18n.translate('xpack.slo.sloDefinitions.tagOptions.exists', {
    defaultMessage: 'Exists'
  })))),
  label: '',
  value: '*'
};