"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloTagsBadge = SloTagsBadge;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_VISIBLE_TAGS = 3;
function SloTagsBadge({
  slo,
  onClick,
  defaultVisibleTags = DEFAULT_VISIBLE_TAGS
}) {
  const [expanded, setExpanded] = (0, _react.useState)(false);
  const tags = slo.tags;
  const visibleTags = expanded ? tags : tags.slice(0, defaultVisibleTags);
  const hasMore = tags.length > defaultVisibleTags;
  const getClickProps = tag => {
    return onClick !== undefined ? {
      onClickAriaLabel: _i18n.i18n.translate('xpack.slo.sloTagsBadge.ariaLabel', {
        defaultMessage: 'Filter with {tag}',
        values: {
          tag
        }
      }),
      onClick: () => onClick(tag)
    } : {};
  };
  if (!tags.length) return null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, visibleTags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: tag,
    onMouseDown: e => e.stopPropagation()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, getClickProps(tag), tag))), hasMore && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    onMouseDown: e => e.stopPropagation()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    color: "text",
    onClick: () => setExpanded(v => !v),
    "data-test-subj": "sloTagsBadgeToggle"
  }, expanded ? _i18n.i18n.translate('xpack.slo.sloTagsBadge.showLess', {
    defaultMessage: 'Show less'
  }) : _i18n.i18n.translate('xpack.slo.sloTagsBadge.showMore', {
    defaultMessage: '+{count} more',
    values: {
      count: tags.length - defaultVisibleTags
    }
  }))));
}