"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IndexDocuments = void 0;
var _react = _interopRequireWildcard(require("react"));
var _searchIndexDocuments = require("@kbn/search-index-documents");
var _i18n = require("@kbn/i18n");
var _use_index_documents = require("../../hooks/api/use_index_documents");
var _use_index_mappings = require("../../hooks/api/use_index_mappings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGINATION = {
  pageIndex: _searchIndexDocuments.INDEX_DOCUMENTS_META_DEFAULT.pageIndex,
  pageSize: _searchIndexDocuments.INDEX_DOCUMENTS_META_DEFAULT.pageSize,
  totalItemCount: _searchIndexDocuments.INDEX_DOCUMENTS_META_DEFAULT.totalItemCount
};
const IndexDocuments = ({
  indexName
}) => {
  var _indexDocuments$data, _pagination$pageSize;
  const [pagination, setPagination] = (0, _react.useState)(DEFAULT_PAGINATION);
  const [searchQuery, setSearchQuery] = (0, _react.useState)('');
  const searchQueryCallback = query => {
    setSearchQuery(query);
  };
  const {
    results: indexDocuments,
    meta: documentsMeta
  } = (0, _use_index_documents.useIndexDocumentSearch)(indexName, pagination, searchQuery);
  const {
    data: mappingData
  } = (0, _use_index_mappings.useIndexMappings)(indexName);
  const docs = (_indexDocuments$data = indexDocuments === null || indexDocuments === void 0 ? void 0 : indexDocuments.data) !== null && _indexDocuments$data !== void 0 ? _indexDocuments$data : [];
  (0, _react.useEffect)(() => {
    setSearchQuery('');
    setPagination(DEFAULT_PAGINATION);
  }, [indexName]);
  return /*#__PURE__*/_react.default.createElement(_searchIndexDocuments.DocumentsOverview, {
    dataTelemetryIdPrefix: "serverless-view-index-documents",
    searchQueryCallback: searchQueryCallback,
    documentComponent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, docs.length === 0 && _i18n.i18n.translate('xpack.serverlessSearch.indexManagementTab.documents.noMappings', {
      defaultMessage: 'No documents found for index'
    }), (docs === null || docs === void 0 ? void 0 : docs.length) > 0 && /*#__PURE__*/_react.default.createElement(_searchIndexDocuments.DocumentList, {
      dataTelemetryIdPrefix: "serverless-view-index-documents",
      docs: docs,
      docsPerPage: (_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : 10,
      isLoading: false,
      mappings: mappingData ? {
        [indexName]: mappingData
      } : undefined,
      meta: documentsMeta !== null && documentsMeta !== void 0 ? documentsMeta : DEFAULT_PAGINATION,
      onPaginate: pageIndex => setPagination({
        ...pagination,
        pageIndex
      }),
      setDocsPerPage: pageSize => setPagination({
        ...DEFAULT_PAGINATION,
        pageSize
      })
    }))
  });
};

// Default Export is needed to lazy load this react component
// eslint-disable-next-line import/no-default-export
exports.IndexDocuments = IndexDocuments;
var _default = exports.default = IndexDocuments;