"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExceptionFilterSchema = exports.exceptions = exports.exceptionListIds = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _default_namespace = require("../../common/default_namespace");
var _response = require("../../response");
var _create_exception_list_item_schema = require("../create_exception_list_item_schema");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const exceptionListId = t.type({
  exception_list_id: t.string,
  namespace_type: _default_namespace.namespaceType
});
const exceptionListIds = exports.exceptionListIds = t.type({
  exception_list_ids: t.array(exceptionListId),
  type: t.literal('exception_list_ids')
});
const exceptions = exports.exceptions = t.type({
  exceptions: t.array(t.union([_response.exceptionListItemSchema, _create_exception_list_item_schema.createExceptionListItemSchema])),
  type: t.literal('exception_items')
});
const optionalExceptionParams = t.exact(t.partial({
  alias: t.string,
  chunk_size: t.number,
  exclude_exceptions: t.boolean
}));
const getExceptionFilterSchema = exports.getExceptionFilterSchema = t.intersection([t.union([exceptions, exceptionListIds]), optionalExceptionParams]);