"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDotExpanderSteps = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the ingest processor steps for the dot expander processor for the given fields.
 * We need to expand the dot notation fields to be able to use them in the field retention processors.
 * Painless treats { "a.b" : "c" } and { "a" : { "b" : "c" } } as different fields.
 */
const getDotExpanderSteps = fields => fields.map(field => {
  return {
    dot_expander: {
      field
    }
  };
});
exports.getDotExpanderSteps = getDotExpanderSteps;