"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.partitionMissingFieldsEvents = void 0;
var _pick = _interopRequireDefault(require("lodash/pick"));
var _get = _interopRequireDefault(require("lodash/get"));
var _partition = _interopRequireDefault(require("lodash/partition"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * partition events in 2 arrays:
 * 1. first one, where no suppressed by field has empty value
 * 2. where any of fields is empty
 */
const partitionMissingFieldsEvents = (events, suppressedBy = [],
// path to fields property within event object. At this point, it can be in root of event object or within event key
fieldsPath = [], mergeSourceAndFields = false) => {
  return (0, _partition.default)(events, event => {
    var _event;
    if (suppressedBy.length === 0) {
      return true;
    }
    const eventFields = fieldsPath.length ? (0, _get.default)(event, fieldsPath) : event;
    const sourceFields = (event === null || event === void 0 ? void 0 : event._source) || (event === null || event === void 0 ? void 0 : (_event = event.event) === null || _event === void 0 ? void 0 : _event._source);
    const fields = mergeSourceAndFields ? {
      ...sourceFields,
      ...eventFields
    } : eventFields;
    const hasMissingFields = Object.keys((0, _pick.default)(fields, suppressedBy)).length < suppressedBy.length;
    return !hasMissingFields;
  });
};
exports.partitionMissingFieldsEvents = partitionMissingFieldsEvents;