"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeEsqlResultInSource = void 0;
var _robust_field_access = require("../../utils/source_fields_merging/utils/robust_field_access");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mergeEsqlResultInSource = (source, esqlResult) => {
  const document = source !== null && source !== void 0 ? source : {};
  Object.keys(esqlResult).forEach(field => {
    if ((0, _robust_field_access.robustGet)({
      key: field,
      document
    })) {
      (0, _robust_field_access.robustUnset)({
        key: field,
        document
      });
    }
    document[field] = esqlResult[field];
  });
  return document;
};
exports.mergeEsqlResultInSource = mergeEsqlResultInSource;