"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectableTimeline = exports.ORIGINAL_PAGE_SIZE = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var _all = require("../../../containers/all");
var _helpers = require("../../open_timeline/helpers");
var i18nTimeline = _interopRequireWildcard(require("../../open_timeline/translations"));
var _empty_value = require("../../../../common/components/empty_value");
var i18n = _interopRequireWildcard(require("../translations"));
var _search_strategy = require("../../../../../common/search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineContentItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: calc(100% - 56px);
`;
const StyledEuiFilterButton = (0, _styledComponents.default)(_eui.EuiFilterButton)`
  border-top: 0;
  border-bottom: 0;
`;
const ORIGINAL_PAGE_SIZE = exports.ORIGINAL_PAGE_SIZE = 50;
const POPOVER_HEIGHT = 260;
const TIMELINE_ITEM_HEIGHT = 50;

/**
 * Modifies options by creating new property `timelineTitle`(with value of `title`), and by setting `title` to undefined.
 * Thus prevents appearing default browser tooltip on option hover (attribute `title` that gets rendered on li element)
 *
 * @param {EuiSelectableOption[]} options
 * @returns {EuiSelectableOption[]} modified options
 */
const replaceTitleInOptions = options => options.map(({
  title,
  ...props
}) => ({
  ...props,
  title: undefined,
  timelineTitle: title !== null && title !== void 0 ? title : ''
}));
const SelectableTimelineComponent = ({
  hideUntitled = false,
  getSelectableOptions,
  onClosePopover,
  onTimelineChange,
  timelineType,
  placeholder
}) => {
  const [pageSize, setPageSize] = (0, _react.useState)(ORIGINAL_PAGE_SIZE);
  const [heightTrigger, setHeightTrigger] = (0, _react.useState)(0);
  const [searchTimelineValue, setSearchTimelineValue] = (0, _react.useState)('');
  const [onlyFavorites, setOnlyFavorites] = (0, _react.useState)(false);
  const {
    fetchAllTimeline,
    timelines,
    loading,
    totalCount: timelineCount
  } = (0, _all.useGetAllTimeline)();
  const selectableListOuterRef = (0, _react.useRef)(null);
  const selectableListInnerRef = (0, _react.useRef)(null);
  const debouncedSetSearchTimelineValue = (0, _react.useMemo)(() => (0, _fp.debounce)(500, setSearchTimelineValue), []);
  const onSearchTimeline = (0, _react.useCallback)(val => {
    debouncedSetSearchTimelineValue(val);
  }, [debouncedSetSearchTimelineValue]);
  const handleOnToggleOnlyFavorites = (0, _react.useCallback)(() => {
    setOnlyFavorites(!onlyFavorites);
  }, [onlyFavorites]);
  const handleOnScroll = (0, _react.useCallback)((totalTimelines, totalCount, scrollOffset) => {
    if (totalTimelines < totalCount && selectableListOuterRef.current && selectableListInnerRef.current) {
      const clientHeight = selectableListOuterRef.current.clientHeight;
      const scrollHeight = selectableListInnerRef.current.clientHeight;
      const clientHeightTrigger = clientHeight * 1.2;
      if (scrollOffset > 10 && scrollHeight - scrollOffset < clientHeightTrigger && scrollHeight > heightTrigger) {
        setHeightTrigger(scrollHeight);
        setPageSize(pageSize + ORIGINAL_PAGE_SIZE);
      }
    }
  }, [heightTrigger, pageSize]);
  const renderTimelineOption = (0, _react.useCallback)((option, searchValue) => {
    const title = (0, _helpers.isUntitled)({
      ...option,
      title: option.timelineTitle
    }) ? i18nTimeline.UNTITLED_TIMELINE : option.timelineTitle;
    const description = option.description != null && option.description.trim().length > 0 ? option.description : null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "spaceBetween",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: `${option.checked === 'on' ? 'check' : 'empty'}`,
      color: "primary"
    })), /*#__PURE__*/_react.default.createElement(TimelineContentItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      direction: "column",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": "timeline"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: title,
      anchorClassName: "eui-textTruncate eui-alignMiddle"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
      search: searchValue
    }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: description,
      anchorClassName: "eui-textTruncate eui-alignMiddle"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      component: "span"
    }, /*#__PURE__*/_react.default.createElement("small", null, description !== null && description !== void 0 ? description : (0, _empty_value.getEmptyTagValue)())))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: `${option.favorite != null && (0, _fp.isEmpty)(option.favorite) ? 'starEmpty' : 'starFilled'}`
    })));
  }, []);
  const handleTimelineChange = (0, _react.useCallback)(options => {
    const selectedTimeline = options.filter(option => option.checked === 'on');
    if (selectedTimeline != null && selectedTimeline.length > 0) {
      var _selectedTimeline$0$g;
      onTimelineChange((0, _fp.isEmpty)(selectedTimeline[0].timelineTitle) ? i18nTimeline.UNTITLED_TIMELINE : selectedTimeline[0].timelineTitle, selectedTimeline[0].id === '-1' ? null : selectedTimeline[0].id, (_selectedTimeline$0$g = selectedTimeline[0].graphEventId) !== null && _selectedTimeline$0$g !== void 0 ? _selectedTimeline$0$g : '');
    }
    onClosePopover();
  }, [onClosePopover, onTimelineChange]);
  const EuiSelectableContent = (0, _react.useCallback)((list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list), []);
  const searchProps = (0, _react.useMemo)(() => ({
    'data-test-subj': 'timeline-super-select-search-box',
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : i18n.SEARCH_BOX_TIMELINE_PLACEHOLDER(timelineType),
    onSearch: onSearchTimeline,
    incremental: false,
    append: /*#__PURE__*/_react.default.createElement(StyledEuiFilterButton, {
      "data-test-subj": "only-favorites-toggle",
      hasActiveFilters: onlyFavorites,
      onClick: handleOnToggleOnlyFavorites
    }, i18nTimeline.ONLY_FAVORITES)
  }), [handleOnToggleOnlyFavorites, onSearchTimeline, onlyFavorites, timelineType, placeholder]);
  const listProps = (0, _react.useMemo)(() => ({
    rowHeight: TIMELINE_ITEM_HEIGHT,
    showIcons: false,
    windowProps: {
      onScroll: ({
        scrollOffset
      }) => handleOnScroll((timelines !== null && timelines !== void 0 ? timelines : []).filter(t => !hideUntitled || t.title !== '').length, timelineCount, scrollOffset),
      outerRef: selectableListOuterRef,
      innerRef: selectableListInnerRef
    }
  }), [handleOnScroll, hideUntitled, timelineCount, timelines]);
  (0, _react.useEffect)(() => {
    fetchAllTimeline({
      pageInfo: {
        pageIndex: 1,
        pageSize
      },
      search: searchTimelineValue,
      sort: {
        sortField: _timeline.SortFieldTimelineEnum.updated,
        sortOrder: _search_strategy.Direction.desc
      },
      onlyUserFavorite: onlyFavorites,
      status: null,
      timelineType
    });
  }, [fetchAllTimeline, onlyFavorites, pageSize, searchTimelineValue, timelineType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "data-test-subj": "selectable-input",
    height: POPOVER_HEIGHT,
    isLoading: loading && timelines == null,
    listProps: listProps,
    renderOption: renderTimelineOption,
    onChange: handleTimelineChange,
    searchable: true,
    searchProps: searchProps,
    singleSelection: true,
    options: replaceTitleInOptions(getSelectableOptions({
      timelines: timelines !== null && timelines !== void 0 ? timelines : [],
      onlyFavorites,
      searchTimelineValue,
      timelineType
    }))
  }, EuiSelectableContent);
};
const SelectableTimeline = exports.SelectableTimeline = /*#__PURE__*/(0, _react.memo)(SelectableTimelineComponent);