"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndgameSecurityEventDetailsLine = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("../helpers");
var _process_draggable = require("../process_draggable");
var _user_host_working_dir = require("../user_host_working_dir");
var _helpers2 = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndgameSecurityEventDetailsLine = exports.EndgameSecurityEventDetailsLine = /*#__PURE__*/_react.default.memo(({
  contextId,
  endgameLogonType,
  endgameSubjectDomainName,
  endgameSubjectLogonId,
  endgameSubjectUserName,
  endgameTargetDomainName,
  endgameTargetLogonId,
  endgameTargetUserName,
  eventAction,
  eventCode,
  eventOutcome,
  hostName,
  id,
  processExecutable,
  processName,
  processPid,
  userDomain,
  userName,
  winlogEventId,
  scopeId
}) => {
  const domain = (0, _helpers2.getTargetUserAndTargetDomain)(eventAction) ? endgameTargetDomainName : userDomain;
  const eventDetails = (0, _helpers2.getEventDetails)({
    eventAction,
    eventOutcome
  });
  const hostNameSeparator = (0, _helpers2.getHostNameSeparator)(eventAction);
  const user = (0, _helpers2.getTargetUserAndTargetDomain)(eventAction) ? endgameTargetUserName : userName;
  const userDomainField = (0, _helpers2.getUserDomainField)(eventAction);
  const userNameField = (0, _helpers2.getUserNameField)(eventAction);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "none",
    wrap: true
  }, eventAction === 'admin_logon' && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "with-special-privileges",
    grow: false
  }, i18n.WITH_SPECIAL_PRIVILEGES), eventAction === 'explicit_user_logon' && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "a-login-was-attempted",
    grow: false
  }, i18n.A_LOGIN_WAS_ATTEMPTED_USING_EXPLICIT_CREDENTIALS), /*#__PURE__*/_react.default.createElement(_user_host_working_dir.UserHostWorkingDir, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    hostName: hostName,
    hostNameSeparator: hostNameSeparator,
    userDomain: domain,
    userDomainField: userDomainField,
    userName: user,
    userNameField: userNameField,
    workingDirectory: undefined
  }), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "event-details",
    grow: false
  }, eventDetails), !(0, _helpers.isNillEmptyOrNotFinite)(endgameLogonType) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "using-logon-type",
    grow: false
  }, i18n.USING_LOGON_TYPE), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "endgame.logon_type",
    queryValue: String(endgameLogonType),
    value: `${endgameLogonType} - ${(0, _helpers2.getHumanReadableLogonType)(endgameLogonType)}`,
    isAggregatable: true,
    fieldType: "keyword"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(endgameTargetLogonId) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, '('), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "using-logon-type",
    grow: false
  }, i18n.TARGET_LOGON_ID), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "endgame.target_logon_id",
    value: endgameTargetLogonId,
    isAggregatable: true,
    fieldType: "keyword"
  })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, ')')), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, i18n.VIA), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggableWithNonExistentProcess, {
    scopeId: scopeId,
    contextId: contextId,
    endgamePid: undefined,
    endgameProcessName: undefined,
    eventId: id,
    processPid: processPid,
    processName: processName,
    processExecutable: processExecutable
  })), !(0, _helpers.isNillEmptyOrNotFinite)(endgameSubjectUserName) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "as-requested-by-subject",
    grow: false
  }, i18n.AS_REQUESTED_BY_SUBJECT), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "endgame.subject_user_name",
    iconType: "user",
    value: endgameSubjectUserName,
    isAggregatable: true,
    fieldType: "keyword"
  }))), endgameSubjectDomainName != null && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "subject-domain-name-domain-separator-text",
    grow: false
  }, '\\'), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "endgame.subject_domain_name",
    value: endgameSubjectDomainName,
    isAggregatable: true,
    fieldType: "keyword"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(endgameSubjectLogonId) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, '('), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "subject-login-id",
    grow: false
  }, i18n.SUBJECT_LOGON_ID), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "endgame.subject_logon_id",
    value: endgameSubjectLogonId,
    isAggregatable: true,
    fieldType: "keyword"
  })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, ')')), (!(0, _helpers.isNillEmptyOrNotFinite)(eventCode) || !(0, _helpers.isNillEmptyOrNotFinite)(winlogEventId)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(eventCode) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    field: "event.code",
    value: eventCode,
    isAggregatable: true,
    fieldType: "keyword"
  })) : /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: id,
    iconType: "logoWindows",
    field: "winlog.event_id",
    value: winlogEventId,
    isAggregatable: true,
    fieldType: "keyword"
  })))));
});
EndgameSecurityEventDetailsLine.displayName = 'EndgameSecurityEventDetailsLine';