"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FILE_UPLOAD_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILE_UPLOAD_ERROR = exports.FILE_UPLOAD_ERROR = {
  CAN_NOT_READ: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.fileUploadError.canNotRead', {
    defaultMessage: 'Failed to read file'
  }),
  CAN_NOT_READ_WITH_REASON: reason => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.fileUploadError.canNotReadWithReason', {
    defaultMessage: 'An error occurred when reading file: {reason}',
    values: {
      reason
    }
  }),
  CAN_NOT_PARSE: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.fileUploadError.canNotParse', {
    defaultMessage: 'Cannot parse the file as either a JSON file or NDJSON file'
  }),
  TOO_LARGE_TO_PARSE: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.fileUploadError.tooLargeToParse', {
    defaultMessage: 'This file is too large to parse'
  }),
  NOT_ARRAY: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.fileUploadError.notArray', {
    defaultMessage: 'The file content is not an array'
  }),
  EMPTY: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.fileUploadError.empty', {
    defaultMessage: 'The file is empty'
  }),
  NOT_OBJECT: _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.fileUploadError.notObject', {
    defaultMessage: 'The file contains non-object entries'
  }),
  WRONG_FORMAT: formatError => {
    return _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.dataInputFlyout.fileUploadError.wrongFormat', {
      defaultMessage: 'The file has wrong format: {formatError}',
      values: {
        formatError
      }
    });
  }
};