"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostOverview = exports.HOST_OVERVIEW_RISK_SCORE_QUERY_ID = void 0;
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _flyout_link = require("../../../flyout/shared/components/flyout_link");
var _use_global_time = require("../../../common/containers/use_global_time");
var _manage_query = require("../../../common/components/page/manage_query");
var _common = require("../../../entity_analytics/common");
var _use_risk_score = require("../../../entity_analytics/api/hooks/use_risk_score");
var _search_strategy = require("../../../../common/search_strategy");
var _types = require("../../../../common/entity_analytics/types");
var _empty_value = require("../../../common/components/empty_value");
var _field_renderers = require("../../../timelines/components/field_renderers/field_renderers");
var _default_renderer = require("../../../timelines/components/field_renderers/default_renderer");
var _first_last_seen = require("../../../common/components/first_last_seen/first_last_seen");
var _inspect = require("../../../common/components/inspect");
var _loader = require("../../../common/components/loader");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _anomaly_scores = require("../../../common/components/ml/score/anomaly_scores");
var _page = require("../../../common/components/page");
var i18n = _interopRequireWildcard(require("./translations"));
var _endpoint_overview = require("./endpoint_overview");
var _overview_description_list = require("../../../common/components/overview_description_list");
var _common2 = require("../../../entity_analytics/components/severity/common");
var _risk_score_header_title = require("../../../entity_analytics/components/risk_score_onboarding/risk_score_header_title");
var _common3 = require("../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HostRiskOverviewWrapper = (0, _styled.default)(_eui.EuiFlexGroup, {
  shouldForwardProp: propName => propName !== '$width'
})`
  padding-top: ${({
  theme: {
    euiTheme
  }
}) => euiTheme.size.m};
  width: ${({
  $width
}) => $width};
`;
const HOST_OVERVIEW_RISK_SCORE_QUERY_ID = exports.HOST_OVERVIEW_RISK_SCORE_QUERY_ID = 'riskInputsTabQuery';
const HostOverview = exports.HostOverview = /*#__PURE__*/_react.default.memo(({
  anomaliesData,
  contextID,
  scopeId,
  data,
  endDate,
  id,
  isInDetailsSidePanel = false,
  // Rather than duplicate the component, alter the structure based on it's location
  isLoadingAnomaliesData,
  indexNames,
  loading,
  narrowDateRange,
  startDate,
  hostName,
  jobNameById,
  isFlyoutOpen = false
}) => {
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const userPermissions = (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities);
  const darkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const filterQuery = (0, _react.useMemo)(() => hostName ? (0, _search_strategy.buildHostNamesFilter)([hostName]) : undefined, [hostName]);
  const {
    deleteQuery,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const {
    data: hostRisk,
    isAuthorized,
    inspect: inspectRiskScore,
    loading: loadingRiskScore,
    refetch: refetchRiskScore
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    riskEntity: _types.EntityType.host,
    skip: hostName == null,
    onlyLatest: false,
    pagination: _common.FIRST_RECORD_PAGINATION
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: inspectRiskScore,
    loading: loadingRiskScore,
    queryId: HOST_OVERVIEW_RISK_SCORE_QUERY_ID,
    refetch: refetchRiskScore,
    setQuery
  });
  const getDefaultRenderer = (0, _react.useCallback)((fieldName, fieldData) => /*#__PURE__*/_react.default.createElement(_default_renderer.DefaultFieldRenderer, {
    rowItems: (0, _fp.getOr)([], fieldName, fieldData),
    attrName: fieldName,
    idPrefix: contextID ? `host-overview-${contextID}` : 'host-overview',
    scopeId: scopeId
  }), [contextID, scopeId]);
  const [hostRiskScore, hostRiskLevel] = (0, _react.useMemo)(() => {
    const hostRiskData = hostRisk && hostRisk.length > 0 ? hostRisk[0] : undefined;
    return [{
      title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
        title: i18n.HOST_RISK_SCORE,
        riskScoreEntity: _types.EntityType.host
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hostRiskData ? Math.round(hostRiskData.host.risk.calculated_score_norm) : (0, _empty_value.getEmptyTagValue)())
    }, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
        title: i18n.HOST_RISK_LEVEL,
        riskScoreEntity: _types.EntityType.host
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_common3.RiskScoreDocTooltip, {
        anchorPosition: "upCenter"
      }))),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hostRiskData ? /*#__PURE__*/_react.default.createElement(_common2.RiskScoreLevel, {
        severity: hostRiskData.host.risk.calculated_level,
        hideBackgroundColor: true
      }) : (0, _empty_value.getEmptyTagValue)())
    }];
  }, [hostRisk]);
  const column = (0, _react.useMemo)(() => [{
    title: i18n.HOST_ID,
    description: data && data.host ? (0, _field_renderers.hostIdRenderer)({
      host: data.host,
      noLink: true,
      scopeId,
      isFlyoutOpen
    }) : (0, _empty_value.getEmptyTagValue)()
  }, {
    title: i18n.FIRST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexNames,
      field: 'host.name',
      value: hostName,
      type: _first_last_seen.FirstLastSeenType.FIRST_SEEN
    })
  }, {
    title: i18n.LAST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexNames,
      field: 'host.name',
      value: hostName,
      type: _first_last_seen.FirstLastSeenType.LAST_SEEN
    })
  }], [data, scopeId, indexNames, hostName, isFlyoutOpen]);
  const firstColumn = (0, _react.useMemo)(() => userPermissions ? [...column, {
    title: i18n.MAX_ANOMALY_SCORE_BY_JOB,
    description: /*#__PURE__*/_react.default.createElement(_anomaly_scores.AnomalyScores, {
      anomalies: anomaliesData,
      startDate: startDate,
      endDate: endDate,
      isLoading: isLoadingAnomaliesData,
      narrowDateRange: narrowDateRange,
      jobNameById: jobNameById
    })
  }] : column, [anomaliesData, column, endDate, isLoadingAnomaliesData, narrowDateRange, startDate, userPermissions, jobNameById]);
  const descriptionLists = (0, _react.useMemo)(() => [firstColumn, [{
    title: i18n.IP_ADDRESSES,
    description: /*#__PURE__*/_react.default.createElement(_default_renderer.DefaultFieldRenderer, {
      rowItems: (0, _fp.getOr)([], 'host.ip', data),
      attrName: 'host.ip',
      idPrefix: contextID ? `host-overview-${contextID}` : 'host-overview',
      scopeId: scopeId,
      render: ip => ip != null ? /*#__PURE__*/_react.default.createElement(_flyout_link.FlyoutLink, {
        field: 'host.ip',
        value: ip,
        scopeId: scopeId,
        isFlyoutOpen: isFlyoutOpen
      }) : (0, _empty_value.getEmptyTagValue)()
    })
  }, {
    title: i18n.MAC_ADDRESSES,
    description: getDefaultRenderer('host.mac', data)
  }, {
    title: i18n.PLATFORM,
    description: getDefaultRenderer('host.os.platform', data)
  }], [{
    title: i18n.OS,
    description: getDefaultRenderer('host.os.name', data)
  }, {
    title: i18n.FAMILY,
    description: getDefaultRenderer('host.os.family', data)
  }, {
    title: i18n.VERSION,
    description: getDefaultRenderer('host.os.version', data)
  }, {
    title: i18n.ARCHITECTURE,
    description: getDefaultRenderer('host.architecture', data)
  }], [{
    title: i18n.CLOUD_PROVIDER,
    description: getDefaultRenderer('cloud.provider', data)
  }, {
    title: i18n.REGION,
    description: getDefaultRenderer('cloud.region', data)
  }, {
    title: i18n.INSTANCE_ID,
    description: getDefaultRenderer('cloud.instance.id', data)
  }, {
    title: i18n.MACHINE_TYPE,
    description: getDefaultRenderer('cloud.machine.type', data)
  }]], [contextID, scopeId, data, firstColumn, getDefaultRenderer, isFlyoutOpen]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_page.OverviewWrapper, {
    direction: isInDetailsSidePanel ? 'column' : 'row',
    "data-test-subj": "host-overview"
  }, !isInDetailsSidePanel && /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: id,
    title: i18n.INSPECT_TITLE,
    inspectIndex: 0
  }), descriptionLists.map((descriptionList, index) => /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    descriptionList: descriptionList,
    key: index
  })), loading && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    overlay: true,
    overlayBackground: darkMode ? _uiTheme.euiDarkVars.euiPageBackgroundColor : _uiTheme.euiLightVars.euiPageBackgroundColor,
    size: "xl"
  }))), isAuthorized && /*#__PURE__*/_react.default.createElement(HostRiskOverviewWrapper, {
    gutterSize: isInDetailsSidePanel ? 'm' : 'none',
    direction: isInDetailsSidePanel ? 'column' : 'row',
    "data-test-subj": "host-risk-overview",
    $width: isInDetailsSidePanel ? '100%' : '50%'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    listItems: [hostRiskScore]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    listItems: [hostRiskLevel]
  }))), data && data.endpoint != null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_page.OverviewWrapper, {
    direction: isInDetailsSidePanel ? 'column' : 'row'
  }, /*#__PURE__*/_react.default.createElement(_endpoint_overview.EndpointOverview, {
    contextID: contextID,
    data: data.endpoint,
    scopeId: scopeId
  }), loading && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    overlay: true,
    overlayBackground: darkMode ? _uiTheme.euiDarkVars.euiPageBackgroundColor : _uiTheme.euiLightVars.euiPageBackgroundColor,
    size: "xl"
  }))) : null);
});
HostOverview.displayName = 'HostOverview';