"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchInsights = void 0;
var _reactQuery = require("@kbn/react-query");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _translations = require("../../translations");
var _workflow_insights = require("../../../../../../../common/endpoint/types/workflow_insights");
var _constants = require("../../../../../../../common/endpoint/constants");
var _kibana = require("../../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchInsights = ({
  endpointId,
  onSuccess
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const toasts = (0, _kibana.useToasts)();
  return (0, _reactQuery.useQuery)([`fetchInsights-${endpointId}`], async () => {
    try {
      const result = await http.get(_constants.WORKFLOW_INSIGHTS_ROUTE, {
        version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
        query: {
          actionTypes: JSON.stringify([_workflow_insights.ActionType.Refreshed]),
          targetIds: JSON.stringify([endpointId]),
          size: 100
        }
      });
      onSuccess();
      return result;
    } catch (error) {
      toasts.addDanger({
        title: _translations.WORKFLOW_INSIGHTS.toasts.fetchInsightsError,
        text: error === null || error === void 0 ? void 0 : error.message
      });
      return [];
    }
  }, {
    refetchOnWindowFocus: false // We need full control over when to refetch
  });
};
exports.useFetchInsights = useFetchInsights;