"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;
var _types = require("../types");
var _translations = require("./translations");
var _translations2 = require("../../app/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabNameMappedToI18nKey = {
  [_types.AdministrationSubTab.endpoints]: _translations.ENDPOINTS_TAB,
  [_types.AdministrationSubTab.policies]: _translations.POLICIES_TAB,
  [_types.AdministrationSubTab.trustedApps]: _translations.TRUSTED_APPS_TAB,
  [_types.AdministrationSubTab.eventFilters]: _translations.EVENT_FILTERS_TAB,
  [_types.AdministrationSubTab.hostIsolationExceptions]: _translations2.HOST_ISOLATION_EXCEPTIONS,
  [_types.AdministrationSubTab.blocklist]: _translations2.BLOCKLIST,
  [_types.AdministrationSubTab.responseActionsHistory]: _translations2.RESPONSE_ACTIONS_HISTORY,
  [_types.AdministrationSubTab.protectionUpdates]: _translations2.PROTECTION_UPDATES,
  [_types.AdministrationSubTab.notes]: _translations2.NOTES
};
function getTrailingBreadcrumbs(params) {
  return [...(params !== null && params !== void 0 && params.tabName ? [params === null || params === void 0 ? void 0 : params.tabName] : []).map(tabName => ({
    text: TabNameMappedToI18nKey[tabName],
    href: ''
  }))];
}