"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelFooter = exports.ASK_AI_ASSISTANT = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_basic_data_from_details_data = require("../shared/hooks/use_basic_data_from_details_data");
var _context = require("../shared/context");
var _use_assistant = require("./hooks/use_assistant");
var _test_ids = require("./test_ids");
var _take_action_button = require("../shared/components/take_action_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASK_AI_ASSISTANT = exports.ASK_AI_ASSISTANT = _i18n.i18n.translate('xpack.securitySolution.ai4soc.flyout.right.footer.askAIAssistant', {
  defaultMessage: 'Ask AI Assistant'
});
/**
 * Bottom section of the flyout that contains the take action button
 */
const PanelFooter = ({
  isRulePreview
}) => {
  const {
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();
  const {
    isAlert
  } = (0, _use_basic_data_from_details_data.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    showAssistant,
    showAssistantOverlay
  } = (0, _use_assistant.useAssistant)({
    dataFormattedForFieldBrowser,
    isAlert
  });
  if (isRulePreview) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    "data-test-subj": _test_ids.FLYOUT_FOOTER_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, showAssistant && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChatByTitle, {
    showAssistantOverlay: showAssistantOverlay,
    text: ASK_AI_ASSISTANT
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_take_action_button.TakeActionButton, null)))));
};
exports.PanelFooter = PanelFooter;
PanelFooter.displayName = 'PanelFooter';