"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationIcon = exports.INTEGRATION_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _integration_icon = require("../../../detections/components/alert_summary/common/integration_icon");
var _use_fetch_integrations = require("../../../detections/hooks/alert_summary/use_fetch_integrations");
var _use_find_rules_query = require("../../../detection_engine/rule_management/api/hooks/use_find_rules_query");
var _use_get_integration_from_rule_id = require("../../../detections/hooks/alert_summary/use_get_integration_from_rule_id");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATION_TEST_ID = exports.INTEGRATION_TEST_ID = 'alert-summary-flyout';
/**
 * Renders the icon for the integration that matches the rule id.
 * It fetches all the rules and packages (integrations) to find the matching by rule id.
 * In AI for SOC, we can retrieve the integration/package that matches a specific rule, via the related_integrations field on the rule.
 */
const IntegrationIcon = exports.IntegrationIcon = /*#__PURE__*/(0, _react.memo)(({
  ruleId
}) => {
  // Fetch all rules. For the AI for SOC effort, there should only be one rule per integration (which means for now 5-6 rules total)
  const {
    data,
    isLoading: ruleIsLoading
  } = (0, _use_find_rules_query.useFindRulesQuery)({});

  // Fetch all packages
  const {
    installedPackages,
    isLoading: integrationIsLoading
  } = (0, _use_fetch_integrations.useFetchIntegrations)();
  const {
    integration
  } = (0, _use_get_integration_from_rule_id.useGetIntegrationFromRuleId)({
    packages: installedPackages,
    rules: data === null || data === void 0 ? void 0 : data.rules,
    ruleId
  });
  return /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
    "data-test-subj": INTEGRATION_TEST_ID,
    iconSize: "l",
    integration: integration,
    isLoading: ruleIsLoading || integrationIsLoading
  });
});
IntegrationIcon.displayName = 'IntegrationIcon';