"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryWidget = exports.ATTACK_DISCOVERY_NO_RESULTS_TEST_ID = exports.ATTACK_DISCOVERY_ACCORDION_TEST_ID = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _attack_discovery_panel = require("./attack_discovery_panel");
var _use_global_time = require("../../../common/containers/use_global_time");
var _use_find_attack_discoveries = require("../../../attack_discovery/pages/use_find_attack_discoveries");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ATTACK_DISCOVERY_NO_RESULTS_TEST_ID = exports.ATTACK_DISCOVERY_NO_RESULTS_TEST_ID = 'ai-for-soc-alert-flyout-attack-discovery-no-results';
const ATTACK_DISCOVERY_ACCORDION_TEST_ID = exports.ATTACK_DISCOVERY_ACCORDION_TEST_ID = 'ai-for-soc-alert-flyout-attack-discovery-accordion';
const NO_RESULTS = _i18n.i18n.translate('xpack.securitySolution.alertSummary.attackDiscovery.noResults', {
  defaultMessage: 'Not part of any attack discoveries'
});
const ADDITIONAL_DISCOVERIES = _i18n.i18n.translate('xpack.securitySolution.alertSummary.attackDiscovery.additionalDiscoveries', {
  defaultMessage: 'View additional Attack discoveries for this alert'
});
/**
 * Component rendered in the attack discovery section of the AI for SOC alert flyout.
 * It renders the current state of the attack discovery the alert is part of.
 */
const AttackDiscoveryWidget = exports.AttackDiscoveryWidget = /*#__PURE__*/(0, _react.memo)(({
  alertId
}) => {
  const {
    assistantAvailability,
    http
  } = (0, _elasticAssistant.useAssistantContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const {
    isLoading,
    data
  } = (0, _use_find_attack_discoveries.useFindAttackDiscoveries)({
    alertIds: [alertId],
    http,
    start: from,
    end: to,
    isAssistantEnabled: assistantAvailability.isAssistantEnabled
  });
  const [attackDiscovery, setAttackDiscovery] = (0, _react.useState)(null);
  const [additionalAttackDiscoveries, setAdditionalAttackDiscoveries] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (data != null && data.data.length > 0) {
      const [firstItem, ...rest] = data.data;
      setAttackDiscovery(firstItem);
      if (rest.length > 0) {
        setAdditionalAttackDiscoveries(rest);
      }
    }
  }, [data]);
  const attackDiscoveryAccordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'attackDiscoveryAccordion'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null) : attackDiscovery ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_attack_discovery_panel.AttackDiscoveryPanel, {
    attackDiscovery: attackDiscovery,
    start: from,
    end: to
  }), additionalAttackDiscoveries.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    "data-test-subj": ATTACK_DISCOVERY_ACCORDION_TEST_ID,
    id: attackDiscoveryAccordionId,
    arrowDisplay: "right",
    buttonContent: ADDITIONAL_DISCOVERIES
  }, additionalAttackDiscoveries.map((ad, i) => /*#__PURE__*/_react.default.createElement(_attack_discovery_panel.AttackDiscoveryPanel, {
    key: i,
    attackDiscovery: ad,
    start: from,
    end: to
  }))) : null) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
            margin: ${euiTheme.size.s} 0;
          `,
    paddingSize: "m",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": ATTACK_DISCOVERY_NO_RESULTS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement("p", null, NO_RESULTS)))));
});
AttackDiscoveryWidget.displayName = 'AttackDiscoveryWidget';