"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersDetailsTabs = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _risk_details_tab_body = require("../../../../entity_analytics/components/risk_details_tab_body");
var _types = require("../../../../../common/entity_analytics/types");
var _model = require("../../store/model");
var _anomalies_user_table = require("../../../../common/components/ml/tables/anomalies_user_table");
var _anomalies_query_tab_body = require("../../../../common/containers/anomalies/anomalies_query_tab_body");
var _constants = require("../constants");
var _events_tab = require("../../../../common/components/events_tab");
var _navigation = require("../navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UsersDetailsTabs = exports.UsersDetailsTabs = /*#__PURE__*/_react.default.memo(({
  deleteQuery,
  filterQuery,
  from,
  indexNames,
  isInitializing,
  setQuery,
  to,
  type,
  detailName,
  userDetailFilter
}) => {
  const tabProps = {
    deleteQuery,
    endDate: to,
    filterQuery,
    indexNames,
    skip: isInitializing || filterQuery === undefined,
    setQuery,
    startDate: from,
    type,
    userName: detailName
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.usersDetailsPagePath}/:tabName(${_model.UsersTableType.authentications})`
  }, /*#__PURE__*/_react.default.createElement(_navigation.AuthenticationsQueryTabBody, tabProps)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.usersDetailsPagePath}/:tabName(${_model.UsersTableType.anomalies})`
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    AnomaliesTableComponent: _anomalies_user_table.AnomaliesUserTable
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.usersDetailsPagePath}/:tabName(${_model.UsersTableType.events})`
  }, /*#__PURE__*/_react.default.createElement(_events_tab.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: userDetailFilter,
    tableId: _securitysolutionDataTable.TableId.usersPageEvents
  }, tabProps))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.usersDetailsPagePath}/:tabName(${_model.UsersTableType.risk})`
  }, /*#__PURE__*/_react.default.createElement(_risk_details_tab_body.RiskDetailsTabBody, (0, _extends2.default)({}, tabProps, {
    riskEntity: _types.EntityType.user,
    entityName: tabProps.userName
  }))));
});
UsersDetailsTabs.displayName = 'UsersDetailsTabs';