"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStoredScript = createStoredScript;
exports.deleteStoredScript = deleteStoredScript;
exports.deleteStoredScripts = deleteStoredScripts;
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _constants = require("../../../../common/constants");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function createStoredScript({
  errorMessage,
  http,
  options,
  renderDocLink,
  signal,
  startServices: {
    notifications,
    ...startServices
  }
}) {
  const res = await http.put(_constants.RISK_SCORE_CREATE_STORED_SCRIPT, {
    version: '1',
    body: JSON.stringify(options),
    signal
  }).catch(e => {
    var _e$body, _e$body2;
    notifications.toasts.addDanger({
      title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.STORED_SCRIPT_CREATION_ERROR_MESSAGE,
      text: (0, _reactKibanaMount.toMountPoint)(renderDocLink ? renderDocLink(e === null || e === void 0 ? void 0 : (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) : e === null || e === void 0 ? void 0 : (_e$body2 = e.body) === null || _e$body2 === void 0 ? void 0 : _e$body2.message, startServices)
    });
  });
  return res;
}
async function deleteStoredScript({
  errorMessage,
  http,
  options,
  renderDocLink,
  signal,
  startServices: {
    notifications,
    ...startServices
  }
}) {
  const res = await http.delete(_constants.RISK_SCORE_DELETE_STORED_SCRIPT, {
    version: '1',
    body: JSON.stringify(options),
    signal
  }).catch(e => {
    var _e$body3, _e$body4;
    notifications.toasts.addDanger({
      title: errorMessage !== null && errorMessage !== void 0 ? errorMessage : _translations.STORED_SCRIPT_DELETION_ERROR_MESSAGE,
      text: (0, _reactKibanaMount.toMountPoint)(renderDocLink ? renderDocLink(e === null || e === void 0 ? void 0 : (_e$body3 = e.body) === null || _e$body3 === void 0 ? void 0 : _e$body3.message) : e === null || e === void 0 ? void 0 : (_e$body4 = e.body) === null || _e$body4 === void 0 ? void 0 : _e$body4.message, startServices)
    });
  });
  return res;
}
async function deleteStoredScripts({
  http,
  signal,
  errorMessage,
  ids,
  startServices
}) {
  const result = await Promise.all(ids.map(id => {
    return deleteStoredScript({
      http,
      signal,
      errorMessage,
      options: {
        id
      },
      startServices
    });
  }));
  return result;
}