"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopRiskScoreContributors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _header_section = require("../../../common/components/header_section");
var _inspect = require("../../../common/components/inspect");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_columns = require("../../../detection_engine/rule_management_ui/components/rules_table/use_columns");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const columns = [{
  name: i18n.RANK_TITLE,
  field: 'rank',
  width: '45px',
  align: 'right'
}, {
  name: i18n.RULE_NAME_TITLE,
  field: 'name',
  sortable: true,
  truncateText: true,
  render: (value, {
    id
  }) => id ? /*#__PURE__*/_react.default.createElement(_use_columns.RuleLink, {
    id: id,
    name: value
  }) : value
}];
const PAGE_SIZE = 5;
const TopRiskScoreContributorsComponent = ({
  rules = [],
  loading,
  queryId,
  toggleStatus,
  toggleQuery
}) => {
  const items = (0, _react.useMemo)(() => {
    return rules === null || rules === void 0 ? void 0 : rules.sort((a, b) => b.rule_risk - a.rule_risk).map(({
      rule_name: name,
      rule_id: id
    }, i) => ({
      rank: i + 1,
      name,
      id
    }));
  }, [rules]);
  const tablePagination = (0, _react.useMemo)(() => ({
    showPerPageOptions: false,
    pageSize: PAGE_SIZE,
    totalItemCount: items.length
  }), [items.length]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "topRiskScoreContributors"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: i18n.TOP_RISK_SCORE_CONTRIBUTORS,
    hideSubtitle: true,
    toggleQuery: toggleQuery,
    toggleStatus: toggleStatus
  })), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: queryId,
    title: i18n.TOP_RISK_SCORE_CONTRIBUTORS
  }))), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "topRiskScoreContributors-table",
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: items,
    columns: columns,
    pagination: tablePagination,
    loading: loading
  })))));
};
const TopRiskScoreContributors = exports.TopRiskScoreContributors = /*#__PURE__*/_react.default.memo(TopRiskScoreContributorsComponent);
TopRiskScoreContributors.displayName = 'TopRiskScoreContributors';