"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkEditDeleteAlertSuppressionConfirmation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _telemetry = require("../../../../../common/lib/telemetry");
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkEditDeleteAlertSuppressionConfirmation = ({
  rulesCount,
  onCancel,
  onConfirm
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
  title: _translations.bulkAlertSuppression.DELETE_CONFIRMATION_TITLE,
  onCancel: onCancel,
  onConfirm: () => {
    onConfirm({
      type: _rule_management.BulkActionEditTypeEnum.delete_alert_suppression
    });
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _telemetry.TELEMETRY_EVENT.SET_ALERT_SUPPRESSION_FOR_THRESHOLD);
  },
  confirmButtonText: _translations.bulkAlertSuppression.DELETE_CONFIRMATION_CONFIRM,
  cancelButtonText: _translations.bulkAlertSuppression.DELETE_CONFIRMATION_CANCEL,
  buttonColor: "danger",
  defaultFocusedButton: "confirm",
  "data-test-subj": "deleteRulesConfirmationModal"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.deleteAlertSuppressionConfirmationModalBody",
  defaultMessage: "This action will remove alert suppression from {rulesCount, plural, one {the chosen rule} other {{rulesCountStrong} rules}}. Click {deleteStrong} to continue.",
  values: {
    rulesCount,
    rulesCountStrong: /*#__PURE__*/_react.default.createElement("strong", null, rulesCount),
    deleteStrong: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.deleteAlertSuppressionConfirmationModalBodyDeleteBtnLabel",
      defaultMessage: "Delete"
    }))
  }
}));
exports.BulkEditDeleteAlertSuppressionConfirmation = BulkEditDeleteAlertSuppressionConfirmation;
BulkEditDeleteAlertSuppressionConfirmation.displayName = 'BulkEditDeleteAlertSuppressionConfirmation';