"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GapStatusFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _multiselect_filter = require("../../../../common/components/multiselect_filter");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const items = [_common.gapStatus.UNFILLED, _common.gapStatus.PARTIALLY_FILLED, _common.gapStatus.FILLED];
const GapStatusFilter = ({
  selectedItems,
  onChange
}) => {
  const renderItem = (0, _react.useCallback)(status => {
    return (0, _utils.getStatusLabel)(status);
  }, []);
  const handleSelectionChange = (0, _react.useCallback)(statuses => {
    onChange(statuses);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_multiselect_filter.MultiselectFilter, {
    "data-test-subj": "rule-gaps-status-filter",
    title: i18n.GAP_STATUS_FILTER_TITLE,
    items: items,
    selectedItems: selectedItems,
    onSelectionChange: handleSelectionChange,
    renderItem: renderItem,
    width: 200
  }));
};
exports.GapStatusFilter = GapStatusFilter;