"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduleItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _shared_imports = require("../../../../shared_imports");
var I18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timeTypeOptions = [{
  value: 's',
  text: I18n.SECONDS
}, {
  value: 'm',
  text: I18n.MINUTES
}, {
  value: 'h',
  text: I18n.HOURS
}, {
  value: 'd',
  text: I18n.DAYS
}];

// move optional label to the end of input
const StyledLabelAppend = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &.euiFlexItem {
    margin-left: 31px;
  }
`;
const StyledEuiFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  max-width: none;

  .euiFormControlLayout__append {
    padding-inline: 0 !important;
  }

  .euiFormControlLayoutIcons {
    color: ${({
  theme
}) => theme.eui.euiColorPrimary};
  }
`;
const MyEuiSelect = (0, _styledComponents.default)(_eui.EuiSelect)`
  min-width: 106px; // Preserve layout when disabled & dropdown arrow is not rendered
  background: ${({
  theme
}) => (0, _eui.transparentize)(theme.eui.euiColorPrimary, 0.1)} !important; // Override focus states etc.
  color: ${({
  theme
}) => theme.eui.euiColorPrimary};
  box-shadow: none;
`;
const getNumberFromUserInput = (input, minimumValue = 0) => {
  const number = parseInt(input, 10);
  if (Number.isNaN(number)) {
    return minimumValue;
  } else {
    return Math.max(minimumValue, Math.min(number, Number.MAX_SAFE_INTEGER));
  }
};
const ScheduleItem = ({
  dataTestSubj,
  field,
  idAria,
  isDisabled,
  minimumValue = 0,
  timeTypes = ['s', 'm', 'h'],
  fullWidth = false
}) => {
  const [timeType, setTimeType] = (0, _react.useState)(timeTypes[0]);
  const [timeVal, setTimeVal] = (0, _react.useState)(0);
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const {
    value,
    setValue
  } = field;
  const onChangeTimeType = (0, _react.useCallback)(e => {
    setTimeType(e.target.value);
    setValue(`${timeVal}${e.target.value}`);
  }, [setValue, timeVal]);
  const onChangeTimeVal = (0, _react.useCallback)(e => {
    const sanitizedValue = getNumberFromUserInput(e.target.value, minimumValue);
    setTimeVal(sanitizedValue);
    setValue(`${sanitizedValue}${timeType}`);
  }, [minimumValue, setValue, timeType]);
  (0, _react.useEffect)(() => {
    if (value !== `${timeVal}${timeType}`) {
      const filterTimeVal = value.match(/\d+/g);
      const filterTimeType = value.match(/[a-zA-Z]+/g);
      if (!(0, _fp.isEmpty)(filterTimeVal) && filterTimeVal != null && !isNaN(Number(filterTimeVal[0])) && Number(filterTimeVal[0]) !== Number(timeVal)) {
        setTimeVal(Number(filterTimeVal[0]));
      }
      if (!(0, _fp.isEmpty)(filterTimeType) && filterTimeType != null && timeTypes.includes(filterTimeType[0]) && filterTimeType[0] !== timeType) {
        setTimeType(filterTimeType[0]);
      }
    }
  }, [timeType, timeTypes, timeVal, value]);

  // EUI missing some props
  const rest = {
    disabled: isDisabled
  };
  const label = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span"
  }, field.label), /*#__PURE__*/_react.default.createElement(StyledLabelAppend, {
    grow: false,
    component: "span"
  }, field.labelAppend)), [field.label, field.labelAppend]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiFormRow, {
    label: label,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: fullWidth,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({
    append: /*#__PURE__*/_react.default.createElement(MyEuiSelect, (0, _extends2.default)({
      fullWidth: true,
      options: timeTypeOptions.filter(type => timeTypes.includes(type.value)),
      onChange: onChangeTimeType,
      value: timeType,
      "aria-label": field.label,
      "data-test-subj": "timeType"
    }, rest)),
    fullWidth: true,
    min: minimumValue,
    max: Number.MAX_SAFE_INTEGER,
    onChange: onChangeTimeVal,
    value: timeVal,
    "data-test-subj": "interval"
  }, rest)));
};
exports.ScheduleItem = ScheduleItem;