"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobsDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _has_ml_admin_permissions = require("../../../../../common/machine_learning/has_ml_admin_permissions");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _ml_admin_jobs_description = require("./admin/ml_admin_jobs_description");
var _ml_user_jobs_description = require("./user/ml_user_jobs_description");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlJobsDescriptionComponent = ({
  jobIds
}) => {
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const isMlUser = (0, _has_ml_user_permissions.hasMlUserPermissions)(mlCapabilities);
  const isMlAdmin = (0, _has_ml_admin_permissions.hasMlAdminPermissions)(mlCapabilities);
  if (isMlAdmin) {
    return /*#__PURE__*/_react.default.createElement(_ml_admin_jobs_description.MlAdminJobsDescription, {
      jobIds: jobIds
    });
  }
  if (isMlUser) {
    return /*#__PURE__*/_react.default.createElement(_ml_user_jobs_description.MlUserJobsDescription, {
      jobIds: jobIds
    });
  }
  return null;
};
const MlJobsDescription = exports.MlJobsDescription = /*#__PURE__*/(0, _react.memo)(MlJobsDescriptionComponent);