"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleSwitchAriaLabel = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ruleSwitchAriaLabel = (name, isActive) => _i18n.i18n.translate('xpack.securitySolution.ruleDetails.ruleSwitch.ariaLabel', {
  values: {
    name,
    action: isActive ? _i18n.i18n.translate('xpack.securitySolution.ruleDetails.ruleSwitch.ariaLabel.switchOff', {
      defaultMessage: 'Switch off'
    }) : _i18n.i18n.translate('xpack.securitySolution.ruleDetails.ruleSwitch.ariaLabel.switchOn', {
      defaultMessage: 'Switch on'
    })
  },
  defaultMessage: '{action} "{name}"'
});
exports.ruleSwitchAriaLabel = ruleSwitchAriaLabel;