"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowCheckBox = exports.HeaderCheckBox = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RowCheckBox = ({
  eventId,
  onRowSelected,
  checked,
  ariaRowindex,
  columnValues,
  disabled,
  loadingEventIds
}) => {
  const handleSelectEvent = (0, _react.useCallback)(event => {
    if (!disabled) {
      onRowSelected({
        eventIds: [eventId],
        isSelected: event.currentTarget.checked
      });
    }
  }, [eventId, onRowSelected, disabled]);
  return loadingEventIds.includes(eventId) ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "event-loader"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": `select-event select-event-${eventId}`,
    id: eventId,
    checked: checked && !disabled,
    disabled: disabled,
    onChange: handleSelectEvent,
    "aria-label": i18n.CHECKBOX_FOR_ROW({
      ariaRowindex,
      columnValues,
      checked
    })
  });
};
exports.RowCheckBox = RowCheckBox;
const HeaderCheckBox = ({
  onSelectAll,
  isSelectAllChecked
}) => {
  const handleSelectPageChange = (0, _react.useCallback)(event => {
    onSelectAll({
      isSelected: event.currentTarget.checked
    });
  }, [onSelectAll]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "data-test-subj": "select-all-events",
    id: "select-all-events",
    checked: isSelectAllChecked,
    onChange: handleSelectPageChange
  });
};
exports.HeaderCheckBox = HeaderCheckBox;