"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionButton = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _react2 = _interopRequireDefault(require("react"));
var _accordion_title = require("./accordion_title");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_kibana_feature_flags = require("../../../../../use_kibana_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AVATAR_SIZE = 24; // px

const AccordionButtonComponent = ({
  connectorName,
  isLoading,
  replacements,
  showAnonymized = false,
  title
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    attackDiscoveryAlertsEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
        gap: ${euiTheme.size.xs};
      `,
    "data-test-subj": "nonWrapping",
    gutterSize: "none",
    responsive: false,
    wrap: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "assistantAvatar",
    grow: false
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            background-color: ${euiTheme.colors.lightestShade};
            border-radius: 50%;
            display: inline;
            height: ${AVATAR_SIZE}px;
            width: ${AVATAR_SIZE}px;
            overflow: hidden;
          `,
    "data-test-subj": "assistantAvatarContainer"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: attackDiscoveryAlertsEnabled && connectorName != null ? connectorName : undefined,
    "data-test-subj": "connectorTooltip",
    position: "right",
    title: attackDiscoveryAlertsEnabled && connectorName != null ? i18n.AI_CONNECTOR : undefined
  }, /*#__PURE__*/_react2.default.createElement(_aiAssistantIcon.AssistantIcon, {
    css: (0, _react.css)`
                transform: translate(5px, -1px);
                overflow: hidden;
              `,
    size: "s"
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_accordion_title.AccordionTitle, {
    isLoading: isLoading,
    replacements: replacements,
    showAnonymized: showAnonymized,
    title: title
  })));
};
AccordionButtonComponent.displayName = 'AccordionButton';
const AccordionButton = exports.AccordionButton = /*#__PURE__*/_react2.default.memo(AccordionButtonComponent);