"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidCriticalityLevels = exports.CriticalityModifiers = exports.CriticalityLevels = exports.CRITICALITY_CSV_SIZE_TOLERANCE_BYTES = exports.CRITICALITY_CSV_MAX_SIZE_BYTES_WITH_TOLERANCE = exports.CRITICALITY_CSV_MAX_SIZE_BYTES = exports.ASSET_CRITICALITY_REQUIRED_ES_INDEX_PRIVILEGES = exports.ASSET_CRITICALITY_PUBLIC_URL = exports.ASSET_CRITICALITY_PUBLIC_LIST_URL = exports.ASSET_CRITICALITY_PUBLIC_CSV_UPLOAD_URL = exports.ASSET_CRITICALITY_PUBLIC_BULK_UPLOAD_URL = exports.ASSET_CRITICALITY_INTERNAL_STATUS_URL = exports.ASSET_CRITICALITY_INTERNAL_PRIVILEGES_URL = exports.ASSET_CRITICALITY_INDEX_PATTERN = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ASSET_CRITICALITY_INTERNAL_URL = `/internal/asset_criticality`;
const ASSET_CRITICALITY_INTERNAL_PRIVILEGES_URL = exports.ASSET_CRITICALITY_INTERNAL_PRIVILEGES_URL = `${ASSET_CRITICALITY_INTERNAL_URL}/privileges`;
const ASSET_CRITICALITY_INTERNAL_STATUS_URL = exports.ASSET_CRITICALITY_INTERNAL_STATUS_URL = `${ASSET_CRITICALITY_INTERNAL_URL}/status`;
const ASSET_CRITICALITY_PUBLIC_URL = exports.ASSET_CRITICALITY_PUBLIC_URL = `/api/asset_criticality`;
const ASSET_CRITICALITY_PUBLIC_CSV_UPLOAD_URL = exports.ASSET_CRITICALITY_PUBLIC_CSV_UPLOAD_URL = `${ASSET_CRITICALITY_PUBLIC_URL}/upload_csv`;
const ASSET_CRITICALITY_PUBLIC_BULK_UPLOAD_URL = exports.ASSET_CRITICALITY_PUBLIC_BULK_UPLOAD_URL = `${ASSET_CRITICALITY_PUBLIC_URL}/bulk`;
const ASSET_CRITICALITY_PUBLIC_LIST_URL = exports.ASSET_CRITICALITY_PUBLIC_LIST_URL = `${ASSET_CRITICALITY_PUBLIC_URL}/list`;
const ASSET_CRITICALITY_INDEX_PATTERN = exports.ASSET_CRITICALITY_INDEX_PATTERN = '.asset-criticality.asset-criticality-*';
const ASSET_CRITICALITY_REQUIRED_ES_INDEX_PRIVILEGES = exports.ASSET_CRITICALITY_REQUIRED_ES_INDEX_PRIVILEGES = {
  [ASSET_CRITICALITY_INDEX_PATTERN]: ['read', 'write']
};

/**
 * enum of asset criticality levels corresponding to the union type {@link CriticalityLevel}
 */
let CriticalityLevels = exports.CriticalityLevels = /*#__PURE__*/function (CriticalityLevels) {
  CriticalityLevels["EXTREME_IMPACT"] = "extreme_impact";
  CriticalityLevels["HIGH_IMPACT"] = "high_impact";
  CriticalityLevels["MEDIUM_IMPACT"] = "medium_impact";
  CriticalityLevels["LOW_IMPACT"] = "low_impact";
  return CriticalityLevels;
}({});
const ValidCriticalityLevels = exports.ValidCriticalityLevels = Object.values(CriticalityLevels);

/**
 * CriticalityModifiers are used to adjust the risk score based on the criticality of the asset.
 */
const CriticalityModifiers = exports.CriticalityModifiers = {
  [CriticalityLevels.EXTREME_IMPACT]: 2,
  [CriticalityLevels.HIGH_IMPACT]: 1.5,
  [CriticalityLevels.MEDIUM_IMPACT]: 1,
  [CriticalityLevels.LOW_IMPACT]: 0.5
};
const CRITICALITY_CSV_MAX_SIZE_BYTES = exports.CRITICALITY_CSV_MAX_SIZE_BYTES = 1024 * 1024; // 1MB
const CRITICALITY_CSV_SIZE_TOLERANCE_BYTES = exports.CRITICALITY_CSV_SIZE_TOLERANCE_BYTES = 1024 * 50; // ~= 50kb
const CRITICALITY_CSV_MAX_SIZE_BYTES_WITH_TOLERANCE = exports.CRITICALITY_CSV_MAX_SIZE_BYTES_WITH_TOLERANCE = CRITICALITY_CSV_MAX_SIZE_BYTES + CRITICALITY_CSV_SIZE_TOLERANCE_BYTES;