"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthorizationService = void 0;
var _management = require("../management");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AuthorizationService {
  setup({
    config,
    http
  }) {
    const isRoleManagementEnabled = () => config.roleManagementEnabled;
    const rolesAPIClient = new _management.RolesAPIClient(http);
    const privilegesAPIClient = new _management.PrivilegesAPIClient(http);
    return {
      isRoleManagementEnabled,
      roles: {
        getRoles: rolesAPIClient.getRoles,
        getRole: rolesAPIClient.getRole,
        deleteRole: rolesAPIClient.deleteRole,
        saveRole: rolesAPIClient.saveRole,
        bulkUpdateRoles: rolesAPIClient.bulkUpdateRoles
      },
      privileges: {
        getAll: privilegesAPIClient.getAll.bind(privilegesAPIClient)
      }
    };
  }
}
exports.AuthorizationService = AuthorizationService;